*
* AUTHOR:   Todd Clark, Federal Reserve Bank of Cleveland, todd.clark@clev.frb.org
* Code associated with Knut Are Aastveit, Todd E. Clark, Andrea Carriero, and Massimiliano Marcellino, 
* "Have Standard VARs Remained Stable Since the Crisis?" Journal of Applied Econometrics
*

********************* USING REAL TIME DATA
********************* this program loops over time to compute point forecasts for 4-variable model in growth rates
********************* we estimate and forecasting using different rolling windows, and then average the forecasts
********************* FORECASTS CONDITIONED ON SPF H=1 FORECASTS
********************* forecasts are dated by outcome observation date, not forecast origin
********************* 

comp datafilename = %unitfnroot("input")+".xls"

dis %dateandtime()
dis %ratsversion()

*********************
********************* BASIC SETUP & PARAMETER ENTRY
*********************

comp ndraws =  5000         ;* we won't simulate, since it won't matter much for point forecasts
comp useactual = 2          ;* 1 to use first available estimate as real time actuals, 2 to use second available as actuals

comp styr = 1947
cal(q) styr:1
comp stsmpl = styr:1	;*earliest period with data

comp fcst =  2008:1        ;* forecasting starts at this quarter
comp stvint = 1996:1       ;* first data vintage
comp endvint = 2015:3      ;* last data vintage
comp endsmpl = endvint - 1
comp nv = endvint-stvint+1

all 3*nv endsmpl
smpl stsmpl endsmpl

comp longst = 1961:1
comp shortst = 1985:1

comp nvar = 4	;* number of variables in the VAR
comp fixlags = 4	;* fixed lag order to use in VAR

*** now define the range over which we will form forecasts (subset of total forecast period)
comp startrange = fcst
comp endrange = endvint

seed 444*endrange

********************************
******************************** setting up and reading in data, for definition of actuals
eqv 1 to 3*nv
GDP96Q1 GDP96Q2 GDP96Q3 GDP96Q4 GDP97Q1 GDP97Q2 GDP97Q3 GDP97Q4 GDP98Q1 GDP98Q2 GDP98Q3 GDP98Q4 $
GDP99Q1 GDP99Q2 GDP99Q3 GDP99Q4 GDP00Q1 GDP00Q2 GDP00Q3 GDP00Q4 GDP01Q1 GDP01Q2 GDP01Q3 GDP01Q4 GDP02Q1 GDP02Q2 $
GDP02Q3 GDP02Q4 GDP03Q1 GDP03Q2 GDP03Q3 GDP03Q4 GDP04Q1 GDP04Q2 GDP04Q3 GDP04Q4 GDP05Q1 GDP05Q2 GDP05Q3 GDP05Q4 $
GDP06Q1 GDP06Q2 GDP06Q3 GDP06Q4 GDP07Q1 GDP07Q2 GDP07Q3 GDP07Q4 GDP08Q1 GDP08Q2 GDP08Q3 GDP08Q4 GDP09Q1 GDP09Q2 $
GDP09Q3 GDP09Q4 GDP10Q1 GDP10Q2 GDP10Q3 GDP10Q4 GDP11Q1 GDP11Q2 GDP11Q3 GDP11Q4 GDP12Q1 GDP12Q2 GDP12Q3 GDP12Q4 GDP13Q1 GDP13Q2 GDP13Q3 GDP13Q4 GDP14Q1 GDP14Q2 $
GDP14Q3 GDP14Q4 GDP15Q1 GDP15Q2 GDP15Q3 $
UR96Q1 UR96Q2 UR96Q3 UR96Q4 UR97Q1 UR97Q2 UR97Q3 UR97Q4 UR98Q1 UR98Q2 UR98Q3 UR98Q4 $
UR99Q1 UR99Q2 UR99Q3 UR99Q4 UR00Q1 UR00Q2 UR00Q3 UR00Q4 UR01Q1 UR01Q2 UR01Q3 UR01Q4 UR02Q1 UR02Q2 $
UR02Q3 UR02Q4 UR03Q1 UR03Q2 UR03Q3 UR03Q4 UR04Q1 UR04Q2 UR04Q3 UR04Q4 UR05Q1 UR05Q2 UR05Q3 UR05Q4 $
UR06Q1 UR06Q2 UR06Q3 UR06Q4 UR07Q1 UR07Q2 UR07Q3 UR07Q4 UR08Q1 UR08Q2 UR08Q3 UR08Q4 UR09Q1 UR09Q2 $
UR09Q3 UR09Q4 UR10Q1 UR10Q2 UR10Q3 UR10Q4 UR11Q1 UR11Q2 UR11Q3 UR11Q4 UR12Q1 UR12Q2 UR12Q3 UR12Q4 UR13Q1 UR13Q2 UR13Q3 UR13Q4 UR14Q1 UR14Q2 $
UR14Q3 UR14Q4 UR15Q1 UR15Q2 UR15Q3 $
PCEX96Q1 PCEX96Q2 PCEX96Q3 PCEX96Q4 PCEX97Q1 PCEX97Q2 PCEX97Q3 PCEX97Q4 PCEX98Q1 PCEX98Q2 PCEX98Q3 PCEX98Q4 $
PCEX99Q1 PCEX99Q2 PCEX99Q3 PCEX99Q4 PCEX00Q1 PCEX00Q2 PCEX00Q3 PCEX00Q4 PCEX01Q1 PCEX01Q2 PCEX01Q3 PCEX01Q4 PCEX02Q1 PCEX02Q2 $
PCEX02Q3 PCEX02Q4 PCEX03Q1 PCEX03Q2 PCEX03Q3 PCEX03Q4 PCEX04Q1 PCEX04Q2 PCEX04Q3 PCEX04Q4 PCEX05Q1 PCEX05Q2 PCEX05Q3 PCEX05Q4 $
PCEX06Q1 PCEX06Q2 PCEX06Q3 PCEX06Q4 PCEX07Q1 PCEX07Q2 PCEX07Q3 PCEX07Q4 PCEX08Q1 PCEX08Q2 PCEX08Q3 PCEX08Q4 PCEX09Q1 PCEX09Q2 $
PCEX09Q3 PCEX09Q4 PCEX10Q1 PCEX10Q2 PCEX10Q3 PCEX10Q4 PCEX11Q1 PCEX11Q2 PCEX11Q3 PCEX11Q4 PCEX12Q1 PCEX12Q2 PCEX12Q3 PCEX12Q4 PCEX13Q1 PCEX13Q2 PCEX13Q3 PCEX13Q4 PCEX14Q1 PCEX14Q2
PCEX14Q3 PCEX14Q4 PCEX15Q1 PCEX15Q2 PCEX15Q3

open data ../data/rtd.gdp.xls
data(format=xls,org=col) / 1 to nv
close
open data ../data/rtd.unemprate.xls
data(format=xls,org=col) / nv+1 to 2*nv
close
open data ../data/rtd.pcex.xls
data(format=xls,org=col) / 2*nv+1 to 3*nv
close
open data ../data/mlydata.xls
data(format=xls,org=col) / FFR itb3m
close

**** for simplicity below, put each series of interest in
**** vectors of series, one series per vintage
**** but only do this for those series for which we have vintages

dec vec[ser] rgdp(nv) ur(nv) pipcex(nv)
do i = 1,nv
  set rgdp(i) = 400.*log(i{0}/i{1})   ;* GDP growth
  set ur(i) = (nv+i){0}               ;* unempl rate
  set pipcex(i) = 400.*log((2*nv+i){0}/(2*nv+i){1})   ;* inflation, core PCE price index
end do i

********************************
******************************** reading in SPF forecasts (leaving out core PCE inflation, since those data only start in 2007)
********************************  note about SPF forecasts:  I transformed the percent change forecasts provided by FRB Phil to be log change forecasts, using log pct = 100*log(g+1), where g = simple percent chg (annualized)
******************************** also note that we adjust the SPF timing to store the forecasts by end date, not forecast origin
dec vec[ser] spf(nvar)
smpl stsmpl endsmpl+1

** GDP growth
comp pos = 1
open data ../data/SPF.gdp.xls
data(format=xls,org=col) / 
close
set spf(pos) = spf1q

** UR
comp pos = 2
open data ../data/SPF.unemprate.xls
data(format=xls,org=col) / 
close
set spf(pos) = spf1q

** core inflation (forecasts don't start until 2007)
comp pos = 3
open data ../data/SPF.pcex.xls
data(format=xls,org=col) / 
close
set spf(pos) = spf1q

** T-bill rate
comp pos = 4
open data ../data/SPF.tbill.xls
data(format=xls,org=col) / 
close
set spf(pos) = spf1q

smpl stsmpl endsmpl

*********************
********************* DATA TRANSFORMATIONS and labels
*********************
dec vec[ser] y(nvar)
comp [vec[str]] varlabel = ||'GDP', 'Unemployment rate', 'Core inflation',  'Fed funds rate'||

** transformation indicator: 0 for levels, 1 for 400*log level or growth rate
comp [vec[int]] transvec = ||1,0,1,0||

** identifier of funds rate position in VAR, which we'll use below for forming conditional forecasts
comp ffrpos = 4

******************************** setting up actuals
******************************** Note (1): This is simpler than in some other projects because we have made sure no vintage is missing an observation at the end of the sample.
******************************** Note (2): Here we date forecasts by the forecast origin, in keeping with SPF dating and old forecast code
comp [vec[int]] horz = ||1,4||          
comp nhorz = %rows(horz)

dec rec[ser] actuals(nvar,nhorz)
clear actuals

**** setting up actuals for variables subject to revision
** GDP growth
comp pos = 1
set(scratch) actuals(pos,1) stvint endvint-useactual = rgdp(t-stvint+1+useactual)(t)
set(scratch) actuals(pos,2) stvint+horz(2)-1 endvint-useactual = (rgdp(t-stvint+1+useactual)(t)+rgdp(t-stvint+1+useactual)(t-1)+rgdp(t-stvint+1+useactual)(t-2)+rgdp(t-stvint+1+useactual)(t-3))/4.
** UR
comp pos = 2
set(scratch) actuals(pos,1) stvint endvint-useactual = ur(t-stvint+1+useactual)(t)
set(scratch) actuals(pos,2) stvint+horz(2)-1 endvint-useactual = ur(t-stvint+1+useactual)(t)
** core PCE inflation
comp pos = 3
set(scratch) actuals(pos,1) stvint endvint-useactual = pipcex(t-stvint+1+useactual)(t)
set(scratch) actuals(pos,2) stvint+horz(2)-1 endvint-useactual = (pipcex(t-stvint+1+useactual)(t)+pipcex(t-stvint+1+useactual)(t-1)+pipcex(t-stvint+1+useactual)(t-2)+pipcex(t-stvint+1+useactual)(t-3))/4.

**** setting up actuals for variables NOT subject to revision
** Fed funds rate
comp pos = 4
set(scratch) actuals(pos,1) stvint endvint = ffr{0}
set(scratch) actuals(pos,2) stvint+horz(2)-1 endvint = ffr{0}

********************************
******************************** stuff for estimation of BVARs
********************************
sou(noecho) ../procedures/BVAR.src                          ;* procedure for forming estimates of VAR with Normal-Wishart prior, and forecasts from the model
sou(noecho) ../procedures/fcmoments.oos.src                 ;* procedure for processing draws of point forecasts

* shrinkage hyperparams for N-W case:  overall tightness, decay on lag, intercept, sum of coefs, initial obs.  We use S-Z 1998 settings.
comp [vec] shrinkage = ||0.2,1.,1000.,10000.,10000.|| 

comp [vec] bvarprior = %fill(nvar,1,0.0)  ;* prior means of first lag of dep variable in each equation; default prior mean is 1.0

******************************** stuff for optimization of prior
comp ngrid = 10
dec vec shrinkgrid(ngrid)
do i = 1,ngrid
 comp shrinkgrid(i) = 0.1*i    ;* overall shrinkage
end do i
set mlseries 1 ngrid = %NA

******************************** stuff for setup of different estimation windows
comp minR = 8*4
comp maxR = 30*4
comp increment = 2*4

comp numR = (maxR - minR)/increment + 1
dis numR

dec vec[int] wsizes(numR)
do i = 1,numR
 comp wsizes(i) = minR + (i-1)*increment
end do i
dis wsizes

dec rec[ser] fcall(nvar*nhorz,numR) fcstore(ndraws,nvar*numR) avgfcdraws(ndraws,nvar)
clear(length=endsmpl+12) fcall

********************************* set up stuff for drawing from the set of forecast densities
dec vec probs_eq(numR) 
comp probs_eq = %const(1./numR)

********************************
******************************** stuff for forecasting and storage
********************************
comp numcond = 0                ;* in some of the sample, we'll impose 0 conditions on the forecasts (i.e., generate unconditional forecasts)

comp [vec[str]] methlabel = ||'avg. window'||
comp nforecasts = %rows(methlabel)
comp smplno = 1

comp [vec[int]] horz = ||1,4||  ;* forecast horizons
comp nhorz = %rows(horz)
comp maxh = horz(nhorz)

dec rec[ser] fcseries(nvar*nhorz,nforecasts) crpsseries(nvar*nhorz,nforecasts)
clear(length=endsmpl+maxh) fcseries crpsseries 

dec rec[int] smplranges(nvar,2)  ;* used in determining estimation sample

***************************************
*************************************** forecasts from models estimated for different windows
*************************************** 
comp basestsmpl = longst

do time = startrange,endrange
 dis '*******************************************************'
 dis '******************************************************* vintage data = ' %datelabel(time)
 dis '******************************************************* time at start of estimation:' %dateandtime()
 
 * vintage # definition
 comp vint = time-stvint+1

 * date range definitions
 comp stpt = basestsmpl-fixlags
 comp endpt = time-1
 smpl stsmpl endpt

 * vector of data series used in estimation
 clear y
 set(scratch) y(1) = rgdp(vint){0}
 set(scratch) y(2) = ur(vint){0}
 set(scratch) y(3) = pipcex(vint){0}
 set(scratch) y(4) = ffr

 do i = 1,nvar
  inquire(series=y(i)) smplranges(i,1) smplranges(i,2)
  comp stpt = %imax(stpt,smplranges(i,1))      
 end do i
 comp stpt = stpt + fixlags   ;* need to adjust starting point of estimation to allow for VAR lag order
 if stpt>basestsmpl
   dis '**************** vintage date = ' %datelabel(time) @42 'missing at start of smpl, start  = ' %datelabel(stpt)

 * loop over different estimation windows and form forecasts
 do nn = 1,numR
  comp starttime = %cputime()
  comp wsize = wsizes(nn)
  comp eststpt = %imax(stpt,endpt-wsize+1) ;* in the event we define a rolling window size that exceeds the available sample size, we'll set the sample size at the available

  ** determining optimal prior
  do n = 1,ngrid
   comp shrinkage(1) = shrinkgrid(n)
   @BVARNWdum(noprpostmean) y eststpt endpt fixlags fixlags 1 bvarprior shrinkage 0 0 Pi_post Sigma_post invOmega_post PiRes Sigmares Uforecastres forecastres logml 
   comp mlseries(n) = logml
  end do n
  extremum(noprint) mlseries 1 ngrid
  comp shrinkage(1) = shrinkgrid(%maxent)
  dis ""
  dis "optimal shrinkage = " shrinkage(1)

  ** now estimate and forecast
  if time<2007:1
   {
    comp numcond = 3
    @BVARNWdum(noprpostmean) y eststpt endpt fixlags fixlags ndraws bvarprior shrinkage maxh numcond Pi_post Sigma_post invOmega_post PiRes Sigmares Uforecastres forecastres marglike 
    # 1 time spf(1)(time)
    # 2 time spf(2)(time)
    # 4 time spf(4)(time)
   }
  else if time>=2007:1.and.time<2009:1
   {
    comp numcond = 4
    @BVARNWdum(noprpostmean) y eststpt endpt fixlags fixlags ndraws bvarprior shrinkage maxh numcond Pi_post Sigma_post invOmega_post PiRes Sigmares Uforecastres forecastres marglike 
    # 1 time spf(1)(time)
    # 2 time spf(2)(time)
    # 3 time spf(3)(time)
    # 4 time spf(4)(time)
   }
  else
   {
    comp numcond = 7
    @BVARNWdum(noprpostmean) y eststpt endpt fixlags fixlags ndraws bvarprior shrinkage maxh numcond Pi_post Sigma_post invOmega_post PiRes Sigmares Uforecastres forecastres marglike 
    # 1 time spf(1)(time)
    # 2 time spf(2)(time)
    # 3 time spf(3)(time)
    # ffrpos time 0.15
    # ffrpos time+1 0.15
    # ffrpos time+2 0.15
    # ffrpos time+3 0.15
   }
   
   ** now store all draws for combination below
   do n = 1,ndraws
    do i = 1,nvar
     set fcstore(n,(i-1)*numr+nn) endpt-(%calendar()(6)) endpt+maxh = forecastres(n,i){0}
    end do i
   end do n

   dis "CPU time for this R (mins) = " (%cputime()-starttime)/60.
 end do nn

 dis ""
 dis "now constructing posterior"
 dis ""

 ************************** construct posterior distribution of average forecast
 ** generate indexes of draws and distributions sampled
 boot randraw 1 ndraws                        ;* draw to be sampled
 set serdraw 1 ndraws = %ranbranch(probs_eq)     ;* distribution to be sampled

 ***** now sample from mixture of distributions
 do i = 1,nvar
  do draw = 1,ndraws
   set avgfcdraws(draw,i) endpt-(%calendar()(6)) endpt+maxh = fcstore(randraw(draw),(i-1)*numr+fix(serdraw(draw))){0}  
  end do draw
 end do i

 ***** now compute mean and scores for average forecast
 @FCMOMENTS avgfcdraws actuals time horz transvec meanres crps
 *** storage of forecast moments into series
 do i = 1,nvar
  do h = 1,nhorz
   comp fcseries((h-1)*nvar+i,smplno)(time+horz(h)-1) = meanres(i,h)   ;* we store forecasts by reference date, not forecast origin
   comp crpsseries((h-1)*nvar+i,smplno)(time+horz(h)-1) = crps(i,h)  
  end do h
 end do i

end do time

***************************************
*************************************** store results and labels in files
*************************************** 

** now create series labels for Excel storage
do j = 1,nforecasts
 do i = 1,nvar
  do h = 1,nhorz
   label fcseries((h-1)*nvar+i,j)
   # 'fc_v'+%string(i)+'_h'+%string(horz(h))+'_s'+%string(j)
   label crpsseries((h-1)*nvar+i,j)
   # 'crps_v'+%string(i)+'_h'+%string(horz(h))+'_s'+%string(j)
  end do h
 end do i
end do j

smpl fcst endsmpl
open copy &datafilename
copy(dates,org=col,for=xls) / fcseries crpsseries
close copy

********************************
******************************** stuff used below in forecast evaluation blocks
********************************
comp nsamples = 1  ;* 2009:Q3-15:Q1
dec vec[rec[int]] dateranges(nhorz)
comp dateranges(1) = ||2009:3,endvint-useactual||
comp dateranges(2) = ||2009:3,endvint-useactual||

do h = 1,nhorz
 do i = 1,nsamples
  dis %datelabel(dateranges(h)(i,1)) %datelabel(dateranges(h)(i,2))
 end do i
end do h

comp [vec[str]] resultslabels = ||"RMSE",  "CRPS"||
dec rec[rec] results(%rows(resultslabels),nhorz)

********************************
******************************** RMSEs and CRPS
********************************

** compute RMSEs and store in matrix, with one matrix per horizon
do h = 1,nhorz
 dim results(1,h)(nforecasts,nsamples*nvar) results(2,h)(nforecasts,nsamples*nvar)
 do n = 1,nforecasts
  do j = 1,nvar
   set sqerror stvint endvint = (actuals(j,h){0} - fcseries((h-1)*nvar+j,n){0})**2.
   set crpsts stvint endvint = crpsseries((h-1)*nvar+j,n){0}
   do k = 1,nsamples
    sstats(mean) dateranges(h)(k,1) dateranges(h)(k,2) sqerror>>mse
    comp results(1,h)(n,(k-1)*nvar+j) = mse^0.5
    sstats(mean) dateranges(h)(k,1) dateranges(h)(k,2) crpsts>>results(2,h)(n,(k-1)*nvar+j)
   end do k
  end do j
 end do n
end do h

** display results
do nn = 1,%rows(resultslabels)
 if nn==1
  {
   dis ''
   dis @22 '                 2009:Q3-15:Q1          '
   dis @22 '_______________________________________________ '
   dis @22 varlabel
  }
 dis ''
 dis '**************** measure: ' resultslabels(nn)
 do h = 1,nhorz
  dis ''
  dis '*********** forecast horizon = ' horz(h)
  dis
  do n = 1,nforecasts
   comp [vec] resultsvec = %xrow(results(nn,h),n)
   dis methlabel(n) @18 #####.###### resultsvec
  end do n
 end do h
end do nn
