*
* AUTHOR:   Todd Clark, Federal Reserve Bank of Cleveland, todd.clark@clev.frb.org
* Code associated with Knut Are Aastveit, Todd E. Clark, Andrea Carriero, and Massimiliano Marcellino, 
* "Have Standard VARs Remained Stable Since the Crisis?" Journal of Applied Econometrics
*

********************* USING REAL TIME DATA
********************* this program loops over time to compute point forecasts for 13-variable model in levels
********************* we estimate and forecast using different rolling windows, and then average the forecasts
********************* forecasts are dated by outcome observation date, not forecast origin
********************* NOTE: TO SPEED UP CALCULATIONS AND REDUCE MEMORY USE, WE USE A FIXED PRIOR INSTEAD OF AN OPTIMIZED PRIOR
********************* 

comp datafilename = %unitfnroot("input")+".xls"

dis %dateandtime()
dis %ratsversion()

*********************
********************* BASIC SETUP & PARAMETER ENTRY
*********************

comp ndraws =  5000         ;* we simulate to get density forecasts
comp useactual = 2          ;* 1 to use first available estimate as real time actuals, 2 to use second available as actuals

comp styr = 1947
cal(q) styr:1
comp stsmpl = styr:1	;*earliest period with data

comp fcst =  2008:1        ;* forecasting starts at this quarter
comp stvint = 1996:1       ;* first data vintage
comp endvint = 2015:3      ;* last data vintage
comp endsmpl = endvint - 1
comp nv = endvint-stvint+1

comp nvar = 13	  ;* number of variables in the VAR
comp nrtvar = 10  ;* number of series for which we don't have/use real time data
comp fixlags = 5  ;* fixed lag order to use in VAR

all nrtvar*nv+(nvar-nrtvar) endsmpl
smpl stsmpl endsmpl

comp longst = 1961:1
comp shortst = 1985:1

*** now define the range over which we will form forecasts (subset of total forecast period)
comp startrange = fcst
comp endrange = endvint

seed 44*endrange

/*
notes on data setup:  To facilitate dealing with a large number of series, we explicitly distinguish the number
of series subject to revision from the ones not subject to revision.  We set up numbered series for all the
vintages of series subject to revision (different series for each vintage) plus single numbered series for the
other series not subject to revision.  This structure is used below in setting up arrays of series used in estimation
and in computing the actuals in forecast evaluation.

notes on units for this model in levels:  for variables in logs, we estimate using variables with units of
100*log(x).  After forming the forecasts, we then annualize quarterly growth rates by multiplying by 4.  We
define actuals at the outset to be consistent with this.
*/

********************************
******************************** setting up and reading in data, for definition of actuals
eqv 1 to nrtvar*nv+(nvar-nrtvar)
GDP96Q1 GDP96Q2 GDP96Q3 GDP96Q4 GDP97Q1 GDP97Q2 GDP97Q3 GDP97Q4 GDP98Q1 GDP98Q2 GDP98Q3 GDP98Q4 $
GDP99Q1 GDP99Q2 GDP99Q3 GDP99Q4 GDP00Q1 GDP00Q2 GDP00Q3 GDP00Q4 GDP01Q1 GDP01Q2 GDP01Q3 GDP01Q4 GDP02Q1 GDP02Q2 $
GDP02Q3 GDP02Q4 GDP03Q1 GDP03Q2 GDP03Q3 GDP03Q4 GDP04Q1 GDP04Q2 GDP04Q3 GDP04Q4 GDP05Q1 GDP05Q2 GDP05Q3 GDP05Q4 $
GDP06Q1 GDP06Q2 GDP06Q3 GDP06Q4 GDP07Q1 GDP07Q2 GDP07Q3 GDP07Q4 GDP08Q1 GDP08Q2 GDP08Q3 GDP08Q4 GDP09Q1 GDP09Q2 $
GDP09Q3 GDP09Q4 GDP10Q1 GDP10Q2 GDP10Q3 GDP10Q4 GDP11Q1 GDP11Q2 GDP11Q3 GDP11Q4 GDP12Q1 GDP12Q2 GDP12Q3 GDP12Q4 GDP13Q1 GDP13Q2 GDP13Q3 GDP13Q4 GDP14Q1 GDP14Q2 $
GDP14Q3 GDP14Q4 GDP15Q1 GDP15Q2 GDP15Q3 $
RCON96Q1 RCON96Q2 RCON96Q3 RCON96Q4 RCON97Q1 RCON97Q2 RCON97Q3 RCON97Q4 RCON98Q1 RCON98Q2 RCON98Q3 RCON98Q4 $
RCON99Q1 RCON99Q2 RCON99Q3 RCON99Q4 RCON00Q1 RCON00Q2 RCON00Q3 RCON00Q4 RCON01Q1 RCON01Q2 RCON01Q3 RCON01Q4 RCON02Q1 RCON02Q2 $
RCON02Q3 RCON02Q4 RCON03Q1 RCON03Q2 RCON03Q3 RCON03Q4 RCON04Q1 RCON04Q2 RCON04Q3 RCON04Q4 RCON05Q1 RCON05Q2 RCON05Q3 RCON05Q4 $
RCON06Q1 RCON06Q2 RCON06Q3 RCON06Q4 RCON07Q1 RCON07Q2 RCON07Q3 RCON07Q4 RCON08Q1 RCON08Q2 RCON08Q3 RCON08Q4 RCON09Q1 RCON09Q2 $
RCON09Q3 RCON09Q4 RCON10Q1 RCON10Q2 RCON10Q3 RCON10Q4 RCON11Q1 RCON11Q2 RCON11Q3 RCON11Q4 RCON12Q1 RCON12Q2 RCON12Q3 RCON12Q4 RCON13Q1 RCON13Q2 RCON13Q3 RCON13Q4 RCON14Q1 RCON14Q2 $
RCON14Q3 RCON14Q4 RCON15Q1 RCON15Q2 RCON15Q3 $
BFI96Q1 BFI96Q2 BFI96Q3 BFI96Q4 BFI97Q1 BFI97Q2 BFI97Q3 BFI97Q4 BFI98Q1 BFI98Q2 BFI98Q3 BFI98Q4 $
BFI99Q1 BFI99Q2 BFI99Q3 BFI99Q4 BFI00Q1 BFI00Q2 BFI00Q3 BFI00Q4 BFI01Q1 BFI01Q2 BFI01Q3 BFI01Q4 BFI02Q1 BFI02Q2 $
BFI02Q3 BFI02Q4 BFI03Q1 BFI03Q2 BFI03Q3 BFI03Q4 BFI04Q1 BFI04Q2 BFI04Q3 BFI04Q4 BFI05Q1 BFI05Q2 BFI05Q3 BFI05Q4 $
BFI06Q1 BFI06Q2 BFI06Q3 BFI06Q4 BFI07Q1 BFI07Q2 BFI07Q3 BFI07Q4 BFI08Q1 BFI08Q2 BFI08Q3 BFI08Q4 BFI09Q1 BFI09Q2 $
BFI09Q3 BFI09Q4 BFI10Q1 BFI10Q2 BFI10Q3 BFI10Q4 BFI11Q1 BFI11Q2 BFI11Q3 BFI11Q4 BFI12Q1 BFI12Q2 BFI12Q3 BFI12Q4 BFI13Q1 BFI13Q2 BFI13Q3 BFI13Q4 BFI14Q1 BFI14Q2 $
BFI14Q3 BFI14Q4 BFI15Q1 BFI15Q2 BFI15Q3 $
RESINV96Q1 RESINV96Q2 RESINV96Q3 RESINV96Q4 RESINV97Q1 RESINV97Q2 RESINV97Q3 RESINV97Q4 RESINV98Q1 RESINV98Q2 RESINV98Q3 RESINV98Q4 $
RESINV99Q1 RESINV99Q2 RESINV99Q3 RESINV99Q4 RESINV00Q1 RESINV00Q2 RESINV00Q3 RESINV00Q4 RESINV01Q1 RESINV01Q2 RESINV01Q3 RESINV01Q4 RESINV02Q1 RESINV02Q2 $
RESINV02Q3 RESINV02Q4 RESINV03Q1 RESINV03Q2 RESINV03Q3 RESINV03Q4 RESINV04Q1 RESINV04Q2 RESINV04Q3 RESINV04Q4 RESINV05Q1 RESINV05Q2 RESINV05Q3 RESINV05Q4 $
RESINV06Q1 RESINV06Q2 RESINV06Q3 RESINV06Q4 RESINV07Q1 RESINV07Q2 RESINV07Q3 RESINV07Q4 RESINV08Q1 RESINV08Q2 RESINV08Q3 RESINV08Q4 RESINV09Q1 RESINV09Q2 $
RESINV09Q3 RESINV09Q4 RESINV10Q1 RESINV10Q2 RESINV10Q3 RESINV10Q4 RESINV11Q1 RESINV11Q2 RESINV11Q3 RESINV11Q4 RESINV12Q1 RESINV12Q2 RESINV12Q3 RESINV12Q4 RESINV13Q1 RESINV13Q2 RESINV13Q3 RESINV13Q4 RESINV14Q1 RESINV14Q2 $
RESINV14Q3 RESINV14Q4 RESINV15Q1 RESINV15Q2 RESINV15Q3 $
IPT96m2 IPT96m5 IPT96m8 IPT96m11 IPT97m2 IPT97m5 IPT97m8 IPT97m11 IPT98m2 IPT98m5 IPT98m8 IPT98m11 $
IPT99m2 IPT99m5 IPT99m8 IPT99m11 IPT00m2 IPT00m5 IPT00m8 IPT00m11 IPT01m2 IPT01m5 IPT01m8 IPT01m11 IPT02m2 IPT02m5 $
IPT02m8 IPT02m11 IPT03m2 IPT03m5 IPT03m8 IPT03m11 IPT04m2 IPT04m5 IPT04m8 IPT04m11 IPT05m2 IPT05m5 IPT05m8 IPT05m11 $
IPT06m2 IPT06m5 IPT06m8 IPT06m11 IPT07m2 IPT07m5 IPT07m8 IPT07m11 IPT08m2 IPT08m5 IPT08m8 IPT08m11 IPT09m2 IPT09m5 $
IPT09m8 IPT09m11 IPT10m2 IPT10m5 IPT10m8 IPT10m11 IPT11m2 IPT11m5 IPT11m8 IPT11m11 IPT12m2 IPT12m5 IPT12m8 IPT12m11 IPT13m2 IPT13m5 IPT13m8 IPT13m11 IPT14m2 IPT14m5  $
IPT14m8 IPT14m11 IPT15m2 IPT15m5 IPT15m8 $
CUM96m2 CUM96m5 CUM96m8 CUM96m11 CUM97m2 CUM97m5 CUM97m8 CUM97m11 CUM98m2 CUM98m5 CUM98m8 CUM98m11 $
CUM99m2 CUM99m5 CUM99m8 CUM99m11 CUM00m2 CUM00m5 CUM00m8 CUM00m11 CUM01m2 CUM01m5 CUM01m8 CUM01m11 CUM02m2 CUM02m5 $
CUM02m8 CUM02m11 CUM03m2 CUM03m5 CUM03m8 CUM03m11 CUM04m2 CUM04m5 CUM04m8 CUM04m11 CUM05m2 CUM05m5 CUM05m8 CUM05m11 $
CUM06m2 CUM06m5 CUM06m8 CUM06m11 CUM07m2 CUM07m5 CUM07m8 CUM07m11 CUM08m2 CUM08m5 CUM08m8 CUM08m11 CUM09m2 CUM09m5 $
CUM09m8 CUM09m11 CUM10m2 CUM10m5 CUM10m8 CUM10m11 CUM11m2 CUM11m5 CUM11m8 CUM11m11 CUM12m2 CUM12m5 CUM12m8 CUM12m11 CUM13m2 CUM13m5 CUM13m8 CUM13m11 CUM14m2 CUM14m5 $
CUM14m8 CUM14m11 CUM15m2 CUM15m5 CUM15m8 $
EMP96m2 EMP96m5 EMP96m8 EMP96m11 $
EMP97m2 EMP97m5 EMP97m8 EMP97m11 EMP98m2 EMP98m5 EMP98m8 EMP98m11 EMP99m2 EMP99m5 EMP99m8 EMP99m11 EMP00m2 EMP00m5 EMP00m8 EMP00m11 $
EMP01m2 EMP01m5 EMP01m8 EMP01m11 EMP02m2 EMP02m5 EMP02m8 EMP02m11 EMP03m2 EMP03m5 EMP03m8 EMP03m11 EMP04m2 EMP04m5 EMP04m8 EMP04m11 $
EMP05m2 EMP05m5 EMP05m8 EMP05m11 EMP06m2 EMP06m5 EMP06m8 EMP06m11 EMP07m2 EMP07m5 EMP07m8 EMP07m11 EMP08m2 EMP08m5 EMP08m8 EMP08m11 $
EMP09m2 EMP09m5 EMP09m8 EMP09m11 EMP10m2 EMP10m5 EMP10m8 EMP10m11 EMP11m2 EMP11m5 EMP11m8 EMP11m11 EMP12m2 EMP12m5 EMP12m8 EMP12m11 EMP13m2 EMP13m5 EMP13m8 EMP13m11 EMP14m2 EMP14m5 $
EMP14m8 EMP14m11 EMP15m2 EMP15m5 EMP15m8 $
UR96Q1 UR96Q2 UR96Q3 UR96Q4 UR97Q1 UR97Q2 UR97Q3 UR97Q4 UR98Q1 UR98Q2 UR98Q3 UR98Q4 $
UR99Q1 UR99Q2 UR99Q3 UR99Q4 UR00Q1 UR00Q2 UR00Q3 UR00Q4 UR01Q1 UR01Q2 UR01Q3 UR01Q4 UR02Q1 UR02Q2 $
UR02Q3 UR02Q4 UR03Q1 UR03Q2 UR03Q3 UR03Q4 UR04Q1 UR04Q2 UR04Q3 UR04Q4 UR05Q1 UR05Q2 UR05Q3 UR05Q4 $
UR06Q1 UR06Q2 UR06Q3 UR06Q4 UR07Q1 UR07Q2 UR07Q3 UR07Q4 UR08Q1 UR08Q2 UR08Q3 UR08Q4 UR09Q1 UR09Q2 $
UR09Q3 UR09Q4 UR10Q1 UR10Q2 UR10Q3 UR10Q4 UR11Q1 UR11Q2 UR11Q3 UR11Q4 UR12Q1 UR12Q2 UR12Q3 UR12Q4 UR13Q1 UR13Q2 UR13Q3 UR13Q4 UR14Q1 UR14Q2 $
UR14Q3 UR14Q4 UR15Q1 UR15Q2 UR15Q3 $
PCE96Q1 PCE96Q2 PCE96Q3 PCE96Q4 PCE97Q1 PCE97Q2 PCE97Q3 PCE97Q4 PCE98Q1 PCE98Q2 PCE98Q3 PCE98Q4 $
PCE99Q1 PCE99Q2 PCE99Q3 PCE99Q4 PCE00Q1 PCE00Q2 PCE00Q3 PCE00Q4 PCE01Q1 PCE01Q2 PCE01Q3 PCE01Q4 PCE02Q1 PCE02Q2 $
PCE02Q3 PCE02Q4 PCE03Q1 PCE03Q2 PCE03Q3 PCE03Q4 PCE04Q1 PCE04Q2 PCE04Q3 PCE04Q4 PCE05Q1 PCE05Q2 PCE05Q3 PCE05Q4 $
PCE06Q1 PCE06Q2 PCE06Q3 PCE06Q4 PCE07Q1 PCE07Q2 PCE07Q3 PCE07Q4 PCE08Q1 PCE08Q2 PCE08Q3 PCE08Q4 PCE09Q1 PCE09Q2 $
PCE09Q3 PCE09Q4 PCE10Q1 PCE10Q2 PCE10Q3 PCE10Q4 PCE11Q1 PCE11Q2 PCE11Q3 PCE11Q4 PCE12Q1 PCE12Q2 PCE12Q3 PCE12Q4 PCE13Q1 PCE13Q2 PCE13Q3 PCE13Q4 PCE14Q1 PCE14Q2 $
PCE14Q3 PCE14Q4 PCE15Q1 PCE15Q2 PCE15Q3 $
PCEX96Q1 PCEX96Q2 PCEX96Q3 PCEX96Q4 PCEX97Q1 PCEX97Q2 PCEX97Q3 PCEX97Q4 PCEX98Q1 PCEX98Q2 PCEX98Q3 PCEX98Q4 $
PCEX99Q1 PCEX99Q2 PCEX99Q3 PCEX99Q4 PCEX00Q1 PCEX00Q2 PCEX00Q3 PCEX00Q4 PCEX01Q1 PCEX01Q2 PCEX01Q3 PCEX01Q4 PCEX02Q1 PCEX02Q2 $
PCEX02Q3 PCEX02Q4 PCEX03Q1 PCEX03Q2 PCEX03Q3 PCEX03Q4 PCEX04Q1 PCEX04Q2 PCEX04Q3 PCEX04Q4 PCEX05Q1 PCEX05Q2 PCEX05Q3 PCEX05Q4 $
PCEX06Q1 PCEX06Q2 PCEX06Q3 PCEX06Q4 PCEX07Q1 PCEX07Q2 PCEX07Q3 PCEX07Q4 PCEX08Q1 PCEX08Q2 PCEX08Q3 PCEX08Q4 PCEX09Q1 PCEX09Q2 $
PCEX09Q3 PCEX09Q4 PCEX10Q1 PCEX10Q2 PCEX10Q3 PCEX10Q4 PCEX11Q1 PCEX11Q2 PCEX11Q3 PCEX11Q4 PCEX12Q1 PCEX12Q2 PCEX12Q3 PCEX12Q4 PCEX13Q1 PCEX13Q2 PCEX13Q3 PCEX13Q4 PCEX14Q1 PCEX14Q2 $
PCEX14Q3 PCEX14Q4 PCEX15Q1 PCEX15Q2 PCEX15Q3 $
ffr spread sp500

open data ../data/rtd.gdp.xls
data(format=xls,org=col) / 1 to nv
close
open data ../data/rtd.rcon.xls
data(format=xls,org=col) / nv+1 to 2*nv
close
open data ../data/rtd.bfi.xls
data(format=xls,org=col) / 2*nv+1 to 3*nv
close
open data ../data/rtd.resinv.xls
data(format=xls,org=col) / 3*nv+1 to 4*nv
close
open data ../data/rtd.ip.xls
data(format=xls,org=col) / 4*nv+1 to 5*nv
close
open data ../data/rtd.cum.xls
data(format=xls,org=col) / 5*nv+1 to 6*nv
close
open data ../data/rtd.payrolls.xls
data(format=xls,org=col) / 6*nv+1 to 7*nv
close
open data ../data/rtd.unemprate.xls
data(format=xls,org=col) / 7*nv+1 to 8*nv
close
open data ../data/rtd.pce.xls
data(format=xls,org=col) / 8*nv+1 to 9*nv
close
open data ../data/rtd.pcex.xls
data(format=xls,org=col) / 9*nv+1 to 10*nv
close

*** read in not-real time data used
open data ../data/mlydata.xls
data(format=xls,org=col) / FFR itb3m sp500 itb10y baa
close
set spread = baa-itb10y

**** set up variable labels; dummy indicator of levels vs logs; and dummy indicator of series with real time data
comp [vec[str]] varlabel = ||'GDP', 'Consumption','Investment','Res. Inv.','Ind. prod.','Capac. util.','Payrolls','Unemployment rate', 'Headline inflation', 'Core inflation','Fed funds rate','Credit spread','S&P500'||
comp [vec[str]] varlabel2 = ||'GDP', 'Unemployment rate', 'Core inflation','Fed funds rate'||
comp [vec[int]] transvec = ||1,1,1,1,1,0,1,0,1,1,0,0,1||
comp [vec[int]] rtseries = ||1,1,1,1,1,1,1,1,1,1,0,0,0||
comp [vec[int]] dispresults = ||1,0,0,0,0,0,0,1,0,1,1,0,0||
comp ffrpos = 11  ;* * identifier of funds rate position in VAR, which we'll use below for forming conditional forecasts

**** for simplicity below, put each series of interest in rectangular arrays of series, one series per vintage
**** for data not subject to revision, we just create copies for each "vintage"
dec vec[ser] y(nvar)
dec rec[ser] yraw(nvar,nv)

comp cnt1 = 0
comp cnt2 = 0
do n = 1,nvar
 if rtseries(n)==1
  {
   comp cnt1 = cnt1+1
   do i = 1,nv
    set yraw(n,i) = ((cnt1-1)*nv+i){0}  
   end do i
  }
 else
  {
   comp cnt2 = cnt2+1
   do i = 1,nv
    set yraw(n,i) = (nrtvar*nv+cnt2){0}  
   end do i
  }
end do n
dis cnt1 cnt2 nrtvar nvar
if cnt1<>nrtvar
 dis '*********** PROBLEM:  NUMBER OF REAL TIME SERIES DOES NOT MATCH UP WITH INTENDED'
endif

******************************** setting up actuals
******************************** Note (1): This is simpler than in some other projects because we have made sure no vintage is missing an observation at the end of the sample.
******************************** Note (2): Here we date forecasts by the forecast origin, in keeping with SPF dating and old forecast code
comp [vec[int]] horz = ||1,4||          
comp nhorz=%rows(horz), maxh=horz(nhorz)

dec rec[ser] actuals(nvar,nhorz)
clear actuals

**** setting up actuals for variables subject to revision
do h = 1,nhorz
 do i = 1,nvar
  if transvec(i)==0
   set actuals(i,h) stvint+horz(h)-1 endvint-useactual = yraw(i,t-stvint+1+useactual)(t)
  else
   {
    if horz(h)>=4
     set actuals(i,h) stvint+horz(h)-1 endvint-useactual = 100.*log(yraw(i,t-stvint+1+useactual)(t)/yraw(i,t-stvint+1+useactual)(t-4))
    else
     set actuals(i,h) stvint+horz(h)-1 endvint-useactual = 400.*log(yraw(i,t-stvint+1+useactual)(t)/yraw(i,t-stvint+1+useactual)(t-1))
   }
 end do i
end do h

********************************
******************************** stuff for estimation of BVARs
********************************
sou(noecho) ../procedures/BVAR.src                          ;* procedure for forming estimates of VAR with Normal-Wishart prior, and forecasts from the model
sou(noecho) ../procedures/fcmoments.oos.src                 ;* procedure for processing draws of point forecasts

* shrinkage hyperparams for N-W case:  overall tightness, decay on lag, intercept, sum of coefs, initial obs.  We use S-Z 1998 settings.
comp [vec] shrinkage = ||0.2,1.,1.,1.,1.|| 

comp [vec] bvarprior = %fill(nvar,1,1.0)  ;* prior means of first lag of dep variable in each equation; default prior mean is 1.0

do i = 1,nvar
 dis i @4 varlabel(i) @25 transvec(i) bvarprior(i) rtseries(i) dispresults(i)
end do i

********************************
******************************** stuff for forecasting and storage
********************************
comp numcond = 0                ;* in some of the sample, we'll impose 0 conditions on the forecasts (i.e., generate unconditional forecasts)

comp [vec[str]] methlabel = ||'avg. window'||
comp nforecasts = %rows(methlabel)

dec rec[ser] fcseries(nvar*nhorz,nforecasts) crpsseries(nvar*nhorz,nforecasts)
clear(length=endsmpl+maxh) fcseries crpsseries 

dec rec[int] smplranges(nvar,2)  ;* used in determining estimation sample

******************************** stuff for setup of different estimation windows
comp minR = 8*4
comp maxR = 30*4
comp increment = 2*4

comp numR = (maxR - minR)/increment + 1
dis numR

dec vec[int] wsizes(numR)
do i = 1,numR
 comp wsizes(i) = minR + (i-1)*increment
end do i
dis wsizes

dec rec[ser] fcall(nvar*nhorz,numR) fcstore(ndraws,nvar*numR) avgfcdraws(ndraws,nvar)
clear(length=endsmpl+12) fcall

********************************* set up stuff for drawing from the set of forecast densities
dec vec probs_eq(numR) 
comp probs_eq = %const(1./numR)

***************************************
*************************************** forecasts from models estimated for different windows
*************************************** 
comp smplno = 1
comp basestsmpl = longst

do time = startrange,endrange
 dis '*******************************************************'
 dis '******************************************************* vintage data = ' %datelabel(time)
 dis '******************************************************* time at start of estimation:' %dateandtime()
 
 * vintage # definition
 comp vint = time-stvint+1

 * date range definitions
 comp stpt = basestsmpl-fixlags
 comp endpt = time-1
 smpl stsmpl endpt

 * vector of data series used in estimation
 clear(length=endsmpl) y
 do i = 1,nvar
  if transvec(i)==1
   set(scratch) y(i) = 100.*log(yraw(i,vint){0})
  else
   set(scratch) y(i) = yraw(i,vint){0}
 end do i

 do i = 1,nvar
  inquire(series=y(i)) smplranges(i,1) smplranges(i,2)
  comp stpt = %imax(stpt,smplranges(i,1))      
  comp endpt = %imin(endpt,smplranges(i,2))      
 end do i
 comp stpt = stpt + fixlags   ;* need to adjust starting point of estimation to allow for VAR lag order
 if stpt>basestsmpl
   dis '**************** vintage date = ' %datelabel(time) @42 'missing at start of smpl, start  = ' %datelabel(stpt)
 if endpt<>(time-1)
   dis '**************** vintage date = ' %datelabel(time) @42 'missing at end of smpl, end  = ' %datelabel(endpt)

 * loop over different estimation windows and form forecasts
 do nn = 1,numR
  comp starttime = %cputime()
  comp wsize = wsizes(nn)
  comp eststpt = %imax(stpt,endpt-wsize+1) ;* in the event we define a rolling window size that exceeds the available sample size, we'll set the sample size at the available

  ** now estimate and forecast
  if time<2009:1
   @BVARNWdum(noprpostmean) y eststpt endpt fixlags fixlags ndraws bvarprior shrinkage maxh numcond Pi_post Sigma_post invOmega_post PiRes Sigmares  forecastres Cforecastres marglike 
  else
   @BVARNWdum(noprpostmean) y eststpt endpt fixlags fixlags ndraws bvarprior shrinkage maxh 4 Pi_post Sigma_post invOmega_post PiRes Sigmares Uforecastres forecastres marglike 
   # ffrpos time 0.15
   # ffrpos time+1 0.15
   # ffrpos time+2 0.15
   # ffrpos time+3 0.15

  *** annualize and difference forecasts as appropriate, to match up to units of interest
  do i = 1,nvar
   if transvec(i)==0
    next
   do j = 1,ndraws
     set forecastres(j,i) endpt-4 endpt+maxh = 4.*forecastres(j,i){0} 
     diff forecastres(j,i) endpt-3 endpt+maxh
   end do j
  end do i
   
  ** now store all draws for combination below
  do n = 1,ndraws
    do i = 1,nvar
     set fcstore(n,(i-1)*numr+nn) endpt-(%calendar()(6)) endpt+maxh = forecastres(n,i){0}
    end do i
  end do n

  dis "CPU time for this R (mins) = " (%cputime()-starttime)/60.
 end do nn

 dis ""
 dis "now constructing posterior"
 dis ""

 ************************** construct posterior distribution of average forecast
 ** generate indexes of draws and distributions sampled
 boot randraw 1 ndraws                        ;* draw to be sampled
 set serdraw 1 ndraws = %ranbranch(probs_eq)     ;* distribution to be sampled

 ***** now sample from mixture of distributions
 do i = 1,nvar
  do draw = 1,ndraws
   set avgfcdraws(draw,i) endpt-(%calendar()(6)) endpt+maxh = fcstore(randraw(draw),(i-1)*numr+fix(serdraw(draw))){0}  
  end do draw
 end do i

 ***** now compute mean and scores for average forecast
 @FCMOMENTS avgfcdraws actuals time horz transvec meanres crps
 *** storage of forecast moments into series
 do i = 1,nvar
  do h = 1,nhorz
   comp fcseries((h-1)*nvar+i,smplno)(time+horz(h)-1) = meanres(i,h)   ;* we store forecasts by reference date, not forecast origin
   comp crpsseries((h-1)*nvar+i,smplno)(time+horz(h)-1) = crps(i,h)  
  end do h
 end do i

end do time

***************************************
*************************************** store results and labels in files
*************************************** 

** now create series labels for Excel storage
do j = 1,nforecasts
 do i = 1,nvar
  do h = 1,nhorz
   label fcseries((h-1)*nvar+i,j)
   # 'fc_v'+%string(i)+'_h'+%string(horz(h))+'_s'+%string(j)
   label crpsseries((h-1)*nvar+i,j)
   # 'crps_v'+%string(i)+'_h'+%string(horz(h))+'_s'+%string(j)
  end do h
 end do i
end do j

smpl fcst endsmpl
open copy &datafilename
copy(dates,org=col,for=xls) / fcseries crpsseries
close copy

********************************
******************************** stuff used below in forecast evaluation blocks
********************************
comp nsamples = 1  ;* 2009:Q3-15:Q1
dec vec[rec[int]] dateranges(nhorz)
comp dateranges(1) = ||2009:3,endvint-useactual||
comp dateranges(2) = ||2009:3,endvint-useactual||

do h = 1,nhorz
 do i = 1,nsamples
  dis %datelabel(dateranges(h)(i,1)) %datelabel(dateranges(h)(i,2))
 end do i
end do h

comp [vec[str]] resultslabels = ||"RMSE",  "CRPS"||
dec rec[rec] results(%rows(resultslabels),nhorz)

********************************
******************************** tabulation and display of results
********************************
comp ndis = 0
do i = 1,nvar
 comp ndis = ndis + dispresults(i)
end do i
dis ndis

** compute results and store in matrices
do h = 1,nhorz
 dim results(1,h)(nforecasts,nsamples*ndis) results(2,h)(nforecasts,nsamples*ndis)
 do n = 1,nforecasts
  comp count = 0
  do j = 1,nvar
   if dispresults(j)==0
    next
   comp count = count+1
   set sqerror stvint endvint = (actuals(j,h){0} - fcseries((h-1)*nvar+j,n){0})**2.
   set crpsts stvint endvint = crpsseries((h-1)*nvar+j,n){0}
   do k = 1,nsamples
    sstats(mean) dateranges(h)(k,1) dateranges(h)(k,2) sqerror>>mse
    comp results(1,h)(n,(k-1)*ndis+count) = mse^0.5
    sstats(mean) dateranges(h)(k,1) dateranges(h)(k,2) crpsts>>results(2,h)(n,(k-1)*ndis+count)
   end do k
  end do j
 end do n
end do h

** display results
do nn = 1,%rows(resultslabels)
 if nn==1
  {
   dis ''
   dis @22 '                   2009:Q3-15:Q1          '
   dis @22 ' _______________________________________________ '
   dis @22 varlabel2
  }
 dis ''
 dis '**************** measure: ' resultslabels(nn)
 do h = 1,nhorz
  dis ''
  dis '*********** forecast horizon = ' horz(h)
  dis
  do n = 1,nforecasts
   comp [vec] resultsvec = %xrow(results(nn,h),n)
   dis methlabel(n) @18 #####.###### resultsvec
  end do n
 end do h
end do nn
