*
* AUTHOR:   Todd Clark, Federal Reserve Bank of Cleveland, todd.clark@clev.frb.org
* Code associated with Knut Are Aastveit, Todd E. Clark, Andrea Carriero, and Massimiliano Marcellino, 
* "Have Standard VARs Remained Stable Since the Crisis?" Journal of Applied Econometrics
*

*********************
********************* Using 4-variable BVAR with fat tails model
********************* assessing probability of break in coefficients
*********************

dis %dateandtime()
dis %ratsversion()

*********************
********************* BASIC SETUP & PARAMETER ENTRY
*********************
comp skipint = 5                     ;* save only every kth draw of MCMC (out of skipint*ndraws)
comp ndraws = 10000                    ;* # of draws retained
comp burnindraws = 2000               ;* # of draws burned

/*
comp skipint = 1                    ;* save only every kth draw of MCMC (out of skipint*ndraws)
comp ndraws = 500                    ;* # of draws retained
comp burnindraws = 100               ;* # of draws burned
*/

comp styr = 1947
cal(q) styr:1
comp stsmpl = styr:1	;*earliest period with data
comp endsmpl = 2015:2	;*last period with data

comp nvar = 4	        ;* number of variables in the VAR
comp fixlags = 2	    ;* fixed lag order to use in VAR

all endsmpl
smpl stsmpl endsmpl

comp seedval = 10000
seed seedval
dis seedval

*********************
********************* READING IN DATA
*********************
open data ../data/qlydata.xls
data(format=xls,org=col) /  gdp	pcexfepi
close

open data ../data/mlydata.xls
data(format=xls,org=col) / ur ffr
close

*********************
********************* DATA TRANSFORMATIONS and setting up data vectors
*********************
dec vec[ser] y(nvar) 
dec vec[str] varlabel(nvar)

** transformation indicator: 0 for levels, 1 for annualized growth rate
comp [vec[int]] transvec = ||1,0,1,0||
*** store data in vectors
comp cnt = 0
dofor i = gdp ur pcexfepi ffr
 comp cnt = cnt + 1
 if transvec(cnt)==0
   set(scratch) y(cnt) = i{0}
 else if transvec(cnt)==1
   set(scratch) y(cnt) = 400.*log(i{0}/i{1})
 comp varlabel(cnt) = %l(i)
end do i

********************************
******************************** stuff for estimation of BVARs
********************************
sou(noecho) ../procedures/BVAR.terrors.src
sou(noecho) ../procedures/BVARwithbreak.terrors.src

comp tdf = 10
comp priordfPhi = nvar+2

******** prior means of first lag of dep variable in each equation (basic intention is to push VAR towards AR(1) models with coef of 0)
comp [vec] bvarprior = %fill(nvar,1,0.0)  ;* default prior mean is 0.0

** shrinkage hyperparameters for constant param model
comp [vec] shrinkage = ||.5,1.,1.|| ;* overall tightness, relative weight on other lags, decay on lag
** shrinkage hyperparameters for break spec
comp [vec] shrinkage2 = ||.5,1.,1.,1000.,0.2|| ;* same, plus tightness of prior on intercept, and tightness of prior on break

*************************************** 
*************************************** single break, 1985-2015 sample
*************************************** 
comp stpt = 1985:1
comp endpt = endsmpl

comp [vec[int]] breakdates = ||2000:1,2000:2,2000:3,2000:4,2001:1,2001:2,2001:3,2001:4,2002:1,2002:2,2002:3,2002:4,$
2005:01,2005:02,2005:03,2005:04,2006:01,2006:02,2006:03,2006:04,2007:01,2007:02,2007:03,2007:04,$
2008:01,2008:02,2008:03,2008:04,2009:01,2009:02,2009:03,2009:04||
comp ncases = %rows(breakdates)+1

dec vec[str] keepdates(ncases)

comp nml = 1  ;* 1 ML estimate we will consider, which is Chib's
dec vec[ser] mlvalues(nml) oddsratios(nml) breakprobs(nml)
clear(length=ncases) mlvalues oddsratios breakprobs

*** model with no break
comp starttime= %cputime()
@BVARfattails(prmean,dochib) y stpt endpt fixlags ndraws burnindraws skipint bvarprior shrinkage priordfPhi tdf $
  0 PiRes_base ARes_base PhiRes_base LambdaRes_base stdevRes SigmaRes ForecastRes chiblike
dis "run time in mins = " (%cputime()-starttime)/60.
comp mlvalues(1)(ncases) = chiblike
comp keepdates(ncases) = "no break"

*** models with breaks
do tt = 1,ncases-1
 comp time = breakdates(tt)
 dis ''
 dis '********************************** break date of ' %datelabel(time)
 comp starttime= %cputime()
 @BVARbreakfattails(prmean,dochib) y stpt endpt time fixlags ndraws burnindraws skipint bvarprior shrinkage2 priordfPhi tdf $
  PiRes_base ARes_base PhiRes_base LambdaRes_base stdevRes chiblike
 dis "run time in mins = " (%cputime()-starttime)/60.
 comp mlvalues(1)(tt) = chiblike
 comp oddsratios(1)(tt) = exp(chiblike - mlvalues(1)(ncases))
 comp keepdates(tt) = %datelabel(time)

end do time

*** model probabilities
do i = 1,nml
 sstats 1 ncases-1 oddsratios(i)(t)>>denom
 comp denom = denom+1.
 set breakprobs(i) 1 ncases-1 = oddsratios(i)(t)/denom
 comp breakprobs(i)(ncases) = 1./denom
end do i

do i = 1,ncases
 dis keepdates(i) @15 #####.#### mlvalues(1)(i) ####.### breakprobs(1)(i) 
end do i

