*
* AUTHOR:   Todd Clark, Federal Reserve Bank of Cleveland, todd.clark@clev.frb.org
* Code associated with Knut Are Aastveit, Todd E. Clark, Andrea Carriero, and Massimiliano Marcellino, 
* "Have Standard VARs Remained Stable Since the Crisis?" Journal of Applied Econometrics
*

*********************
********************* Using 4-variable BVAR in growth rates with Normal-Wishart prior, 
********************* testing for breaks in coefficients
*********************  specification:  full sample coefs and coef changes, with constant error variance
********************* 
*********************

dis %dateandtime()
dis %ratsversion()

*********************
********************* BASIC SETUP & PARAMETER ENTRY
*********************
comp styr = 1947
cal(q) styr:1
comp stsmpl = styr:1	;*earliest period with data
comp endsmpl = 2015:2	;*last period with data -- GDP and components for Q1 are actually forecasts, based on MA and staff sectoral models

comp nvar = 4	        ;* number of variables in the VAR
comp fixlags = 2	    ;* fixed lag order to use in VAR

all endsmpl
smpl stsmpl endsmpl

*********************
********************* READING IN DATA
*********************
open data ../data/qlydata.xls
data(format=xls,org=col) /  gdp	pcexfepi
close

open data ../data/mlydata.xls
data(format=xls,org=col) / ur ffr
close

*********************
********************* DATA TRANSFORMATIONS and setting up data vectors
*********************
dec vec[ser] y(nvar) 
dec vec[str] varlabel(nvar)

** transformation indicator: 0 for levels, 1 for annualized growth rate
comp [vec[int]] transvec = ||1,0,1,0||
*** store data in vectors
comp cnt = 0
dofor i = gdp ur pcexfepi ffr
 comp cnt = cnt + 1
 if transvec(cnt)==0
   set(scratch) y(cnt) = i{0}
 else if transvec(cnt)==1
   set(scratch) y(cnt) = 400.*log(i{0}/i{1})
 comp varlabel(cnt) = %l(i)
end do i

********************************
******************************** stuff for estimation of BVARs
********************************
sou(noecho) ../procedures/BVAR.src               ;* procedure for constant parameter BVAR, conjugate Normal-Wishart
sou(noecho) ../procedures/BVARwithbreak.src      ;* procedure for BVAR with discrete break, conjugate Normal-Wishart

comp [vec] bvarprior = %fill(nvar,1,0.0)  ;* prior means of first lag of dep variable in each equation; default prior mean is 1.0
comp [vec] shrinkage = ||0.2,1.,1000.,10000.,10000.||   ;* hyperparameters for constant parameter model
*                              - Shrinkage(1): Baseline tightness parameter. 
*                              - Shrinkage(2): Lag length shrinkage parameter.      
*                              - Shrinkage(3): tightness of prior on intercept (high means loose)
*                              - Shrinkage(4): hyperparam for sum of coefs (high means loose)
*                              - Shrinkage(5): hyperparam for initial obs (high means loose)

comp [vec] shrinkage2 = ||0.2,1.,1000.,0.1||          ;* hyperparameters for model with break
*                              - Shrinkage(1): Baseline tightness parameter. 
*                              - Shrinkage(2): Lag length shrinkage parameter.      
*                              - Shrinkage(3): tightness of prior on intercept
*                              - Shrinkage(4): tightness of prior on break

******************************** stuff for optimization of prior
comp ngrid = 10
dec vec shrinkgrid1(ngrid) shrinkgrid2(ngrid)
do i = 1,ngrid
 comp shrinkgrid1(i) = 0.10*i    ;* overall shrinkage
end do i
comp shrinkgrid2 = 0.5*shrinkgrid1  ;* break shrinkage, specified to be tighter than overall shrinkage

comp ngridtot = %rows(shrinkgrid1)*%rows(shrinkgrid2)
dec rec shrinkgrid(ngridtot,2)

comp cnt = 0
do i = 1,%rows(shrinkgrid1)
 do j = 1,%rows(shrinkgrid2)
   comp cnt = cnt+1
   comp shrinkgrid(cnt,1) = shrinkgrid1(i)
   comp shrinkgrid(cnt,2) = shrinkgrid2(j)
 end do j
end do i

set mlseries 1 ngridtot = %NA

comp baseshrinkage = shrinkage
comp baseshrinkage2 = shrinkage2

*************************************** 
*************************************** single break, 1985-2015 sample
*************************************** 
comp stpt = 1985:1
comp endpt = endsmpl

comp [vec[int]] breakdates = ||2000:1,2000:2,2000:3,2000:4,2001:1,2001:2,2001:3,2001:4,2002:1,2002:2,2002:3,2002:4,$
2005:01,2005:02,2005:03,2005:04,2006:01,2006:02,2006:03,2006:04,2007:01,2007:02,2007:03,2007:04,$
2008:01,2008:02,2008:03,2008:04,2009:01,2009:02,2009:03,2009:04||
comp ncases = %rows(breakdates)+1

clear(length=ncases) mlvalues oddsratios breakprobs
dec vec[str] keepdates(ncases)
dec rec optshrink(ncases,2)

*************************************** fixed prior
*** model with no break
@BVARNWdum(noprpostmean) y stpt endpt fixlags fixlags 1 bvarprior shrinkage 0 0 Pi_post Sigma_post invOmega_post PiRes Sigmares UForecastRes CForecastRes logml
comp mlvalues(ncases) = logml 
comp keepdates(ncases) = "no break"

*** models with breaks
do tt = 1,ncases-1
 comp time = breakdates(tt)
 @BVARNWwithbreak(noprpostmean) y stpt endpt time fixlags fixlags 1 bvarprior shrinkage2 Pi_post Sigma_post PiRes Sigmares logml predlikevec
 comp mlvalues(tt) = logml 
 comp oddsratios(tt) = exp(logml - mlvalues(ncases))
 comp keepdates(tt) = %datelabel(time)
end do time

*** model probabilities
sstats 1 ncases-1 oddsratios(t)>>denom
comp denom = denom+1.
set breakprobs 1 ncases-1 = oddsratios(t)/denom
comp breakprobs(ncases) = 1./denom

do i = 1,ncases
 dis keepdates(i) @15 #####.#### mlvalues(i)  ###.### breakprobs(i)
end do i

*************************************** optimized prior
*** model with no break
do n = 1,ngrid
  comp shrinkage(1) = shrinkgrid1(n)
  @BVARNWdum(noprpostmean) y stpt endpt fixlags fixlags 1 bvarprior shrinkage 0 0 Pi_post Sigma_post invOmega_post PiRes Sigmares UForecastRes CForecastRes logml predlike
  comp mlseries(n) = logml
end do n
comp keepdates(ncases) = "no break"
extremum(noprint) mlseries 1 ngrid
comp mlvalues(ncases) = %maximum
comp optshrink(ncases,1) = shrinkgrid1(%maxent)

*** models with breaks
do tt = 1,ncases-1
 comp time = breakdates(tt)
 do n = 1,ngridtot
  comp shrinkage2(1) = shrinkgrid(n,1)
  comp shrinkage2(4) = shrinkgrid(n,2)
  @BVARNWwithbreak(noprpostmean) y stpt endpt time fixlags fixlags 1 bvarprior shrinkage2 Pi_post Sigma_post PiRes Sigmares logml predlikevec
  comp mlseries(n) = logml
 end do n
 extremum(noprint) mlseries 1 ngridtot
 comp optshrink(tt,1) = shrinkgrid(%maxent,1)
 comp optshrink(tt,2) = shrinkgrid(%maxent,2)
 comp logml = %maximum
 comp mlvalues(tt) = logml
 comp oddsratios(tt) = exp(logml - mlvalues(ncases))
 comp keepdates(tt) = %datelabel(time)
end do time

*** model probabilities
sstats 1 ncases-1 oddsratios(t)>>denom
comp denom = denom+1.
set breakprobs 1 ncases-1 = oddsratios(t)/denom
comp breakprobs(ncases) = 1./denom

do i = 1,ncases
 if i==1
  {
   dis ""
   dis "break date lambda1 lambda2    log ML      prob"
  }
 dis keepdates(i) @11 ###.## optshrink(i,1) optshrink(i,2) @28 #####.#### mlvalues(i)  ###.### breakprobs(i)
end do i
