*
* AUTHOR:   Todd Clark, Federal Reserve Bank of Cleveland, todd.clark@clev.frb.org
* Code associated with Knut Are Aastveit, Todd E. Clark, Andrea Carriero, and Massimiliano Marcellino, 
* "Have Standard VARs Remained Stable Since the Crisis?" Journal of Applied Econometrics
*

*********************
********************* Using 4-variable BVAR in growth rates with Normal-Wishart prior AND BREAK IN COEFFICIENTS
********************* this program uses forecasts of all variables (but GDP) conditional on actual path of GDP
********************* as a check of model stability.  Model is estimated with data through 2015:Q2
*********************

dis %dateandtime()
dis %ratsversion()

*********************
********************* BASIC SETUP & PARAMETER ENTRY
*********************
env nowshowgraphs 
gsave "Figure4_*.rgf"
grparm header 18 subheader 16 keylabeling 24 hlabel 24 axislabeling 22 footer 12

comp ndraws =  10000                   ;* number of draws
*comp ndraws =  1000                   ;* number of draws retained

comp styr = 1947
cal(q) styr:1
comp stsmpl = styr:1	;*earliest period with data
comp endsmpl = 2015:2	;*last period with data -- GDP and components for Q1 are actually forecasts, based on MA and staff sectoral models

comp usest = 1985:1
comp breakdate = 2008:2
comp shortend = 2008:2  ;* forecasting starts in period shortend+1

comp nvar = 4	        ;* number of variables in the VAR
comp fixlags = 4	;* fixed lag order to use in VAR

all endsmpl
smpl stsmpl endsmpl

comp seedval = 128*%month(endsmpl)*%year(endsmpl)
seed seedval
dis seedval

*********************
********************* READING IN DATA
*********************
open data ../data/qlydata.xls
data(format=xls,org=col) /  gdp	pcexfepi
close

open data ../data/mlydata.xls
data(format=xls,org=col) / ur ffr
close

*********************
********************* DATA TRANSFORMATIONS and setting up data vectors
*********************
dec vec[ser] y(nvar)
comp [vec[str]] varlabel = ||'GDP', 'Unemployment rate', 'Core inflation',  'Fed funds rate'||

** transformation indicator: 0 for levels, 1 for annualized growth rate
comp [vec[int]] transvec = ||1,0,1,0||

*** store data in vectors
comp cnt = 0
dofor i = gdp ur pcexfepi ffr
 comp cnt = cnt + 1
 if transvec(cnt)==0
   set(scratch) y(cnt) = i{0}
 else if transvec(cnt)==1
   set(scratch) y(cnt) = 400.*log(i{0}/i{1})
end do i

********************************
******************************** stuff for estimation of BVARs
********************************
sou(noecho) ../procedures/BVARwithbreak.src               ;* procedure for BVAR with discrete break, conjugate Normal-Wishart
sou(noecho) ../procedures/conditforecastbyKF.src ;* procedure for using Kalman filter-based approach to computing conditional forecasts
sou(noecho) ../procedures/fcmoments.src          ;* procedure for forming forecast means, percentiles, PITS, etc.

comp [vec] bvarprior = %fill(nvar,1,0.0)  ;* prior means of first lag of dep variable in each equation

comp [vec] shrinkage2 = ||0.2,1.,1000.,0.1|| 
*                              - Shrinkage(1): Baseline tightness parameter. 
*                              - Shrinkage(2): Lag length shrinkage parameter.      
*                              - Shrinkage(3): tightness of prior on intercept
*                              - Shrinkage(4): tightness of prior on break

do i = 1,nvar
 dis varlabel(i) @14 ####### transvec(i) ######.# bvarprior(i) 
end do i

*************************************** first estimate models
*************************************** single break in 2008:Q2, 1985-2015:Q2 sample
*************************************** 
comp stpt = usest
comp endpt = endsmpl

*************************************** fixed prior
@BVARNWwithbreak(prpostmean) y stpt endpt breakdate fixlags fixlags ndraws bvarprior shrinkage2 Pi_post Sigma_post Piallfixed Sigmafixed logml 

*************************************** now construct draws of VAR coefs to feed into conditional forecast construction
*************************************** post-break coefficients = pre-break + coef.change
comp ncoef = nvar*fixlags+1      ;* number of coefficients in each equation
dec vec[rec] Pifixed(ndraws) 
 dis ####.#### Piallfixed(1)
do d = 1,ndraws
 comp Pifixed(d) = %xsubmat(Piallfixed(d),1,ncoef,1,nvar)+%xsubmat(Piallfixed(d),ncoef+1,2*ncoef,1,nvar)
end do d

*********************
********************* stuff for fan chart calculation
*********************
dec ser[vec] ycond

comp nlines = 7   ;* number of fan chart lines, for median and 50 pct bands, and 70 pct bands
dec rec[ser] bandvals(nvar,nlines)
dec vec fractiles
clear bandvals
dec vec tempvec(ndraws)

comp [vec] pctvec = ||.5,.25,.75,.15,.85,.05,.95||  ;* vector of percentiles for which we will report bands

comp footer = 'Notes:  Black line:  median.  Red line:  actual.  Bands:  50%, 70%, and 90%.'
comp header = 'Forecasts from 4-variable BVAR with break, conditional on actual GDP'
comp headerforspr = 'Forecasts from 4-variable BVAR with break, conditional on actual GDP and FFR'

** figure out how many pages of charts we'll have
comp perpage = 6
comp npages = nvar/perpage
if npages*perpage<nvar
 comp npages = npages+1
endif

*************************************** 
*************************************** conditional forecasts from model estimated with data starting in 1985
*************************************** fixed prior
comp maxh = endsmpl-shortend
dis maxh

*************************************** conditions on just GDP

**** now get conditional forecasts via new Kalman filter code
gset ycond shortend+1 shortend+maxh = %fill(nvar,1,%NA)
do time = shortend+1,shortend+maxh
 comp ycond(time)(1) = y(1)(time)
end do time

@condfcbyKF y ycond usest shortend fixlags ndraws maxh Pifixed Sigmafixed ForecastRes

do looptime = shortend+1,shortend+maxh
 do n = 1,nvar
  ewise tempvec(i) = forecastres(i,n)(looptime)
  comp fractiles = %fractiles(tempvec,pctvec)
  do k = 1,nlines
   comp bandvals(n,k)(looptime) = fractiles(k)
  end do k  
 end do n
end do looptime

*** creating fan chart
smpl shortend+1 shortend+maxh

comp subheader = 'Fixed baseline prior; estimation sample: 1985-2015:Q2'

comp n = 0
do i = 1,npages
 spgraph(vfields=2,hfields=2,header=header,subheader=subheader,samesize,footer=footer)
 do j = 1,perpage
  comp n = n + 1
  if n>nvar
   break
  comp header2 = varlabel(n)
  extremum(noprint) bandvals(n,nlines)
  comp max = %maximum
  extremum(noprint) bandvals(n,nlines-1)
  comp min = %minimum
  
  graph(header=header2,ovcount=nlines-1,overlay=fan,ovsame,dates) nlines+1 
  # bandvals(n,1)
  # y(n) / 4
  # bandvals(n,6) / 2
  # bandvals(n,4) / 2
  # bandvals(n,2) / 2
  # bandvals(n,3) / 2
  # bandvals(n,5) / 2
  # bandvals(n,7) / 2
 end do j
 spgraph(done)
end do i
