%%%%% Replication file 
%% Knut Are Aastveit, Andrea Carriero, Todd Clark and Massimiliano Marcellino, "Have Standard VARs Remained Stable Since the Crisis?", Journal of Applied Econometrics, forthcoming.
%% Regime-swtiching VAR with breaks in VAR coefficients, 2 regimes (referred to as RS-C). The code replicates the results for RS-C in Table 2 in the main text and Figure 3 in the supplementary appendix
%% The codes are partly based on programs from Barnett A, Mumtaz H, Theodoridis K. 2014. Forecasting UK GDP growth and inflation under structural change: a comparison of models with time-varying parameters. International Journal of Forecasting 30: 129-143. 


clear;
addpath('./functions')
sfolder='./results';


%%%% Settings
T0=1;
VarBench.lamdaP=10;
VarBench.tauP=VarBench.lamdaP*10;
VarBench.epsilonP=1/1000;
HORZ=4;
REPS=55000;
BURN=50000;

MaxTrys=500;

%%%%% Load Data
data=xlsread('Data_USA.xlsx');
data=data(100:end,:);    %%%% Use sample starting in 1985
  
[ s00x ] = getstart( data,2,300,T0 );
 
%%%%%%%%Estimate two lag model
VarBench.L=2;
 [fsave2,bdic2,bsave12,bsave22,sigmaS12,psave2,regime2,probstate21,probstate22]=...
    estimate2regimesC(data,VarBench,HORZ,REPS,BURN,MaxTrys,s00x,T0);

Probstate21=probstate21(5:5:end,:);
Probstate22=probstate22(5:5:end,:);
PS21=mean(Probstate21,1)';
PS22=mean(Probstate22,1)
PS=[PS21 PS22];
regime22=regime2(5:5:end,:);
Regime2=mean(regime22,1)';

%%%% Plotting regimes
figure
subplot(2, 1, 1)  
T=size(PS21,1);
            timex=[1:20:T,T];
            fss=12;
            plot(PS21,'-r','LineWidth',5);
            ylim([0 1])
            xlim([1 T]);
            set(gca,'XTick',timex(1:end-1));
            set(gca,'YTick',(0:0.2:1));
            set(gca,'XTickLabel',{'1985','1990','1995','2000','2005','2010','2015'},'FontSize',fss);
            title('Prob of regime # 1','fontsize',16)
         
subplot(2, 1, 2)  
box('on');
            timex=[1:20:T,T];
            plot(PS22,'-r','LineWidth',5);
            ylim([0 1])
            xlim([1 T]);
            set(gca,'XTick',timex(1:end-1));
            set(gca,'YTick',(0:0.2:1));
            set(gca,'XTickLabel',{'1985','1990','1995','2000','2005','2010','2015'},'FontSize',fss);
            title('Prob of regime # 2','fontsize',16)
            
  figname=strvcat(strcat(sprintf('RS_C_Regimes2_Coeff.pdf')));
  saveas(gcf, figname);           
             