function [DiagSpect, CohereSpec, omegafreq]=varspectrum(G,impact,H,Sigma,T)

Betamat = G;
Sigmamat = impact*Sigma*impact';
nolags = 1;

TT = 2*(floor(T/2)) + 1;
[nob n] = size(H);

% FullSpect = zeros(n,n,(TT-1)/2);
CohereSpec = zeros(nob,nob,(TT-1)/2);
% GainSpec = zeros(n,n,(TT-1)/2);
% PhaseSpec = zeros(n,n,(TT-1)/2);
DiagSpect = zeros(n,(TT-1)/2);
omegafreq = zeros((TT-1)/2,1);
% kk = zeros((TT-1)/2,1);
for k=1:(TT-1)/2;
    omegafreq(k,1)=(2*pi*k)/T;
    term_1=zeros(n);
    term_2=zeros(n);
    for p=1:nolags;
        term_1=term_1+(Betamat(:,(p-1)*n+1:p*n)*exp(-i*omegafreq(k,1)*p));
        term_2=term_2+(Betamat(:,(p-1)*n+1:p*n)'*exp(i*omegafreq(k,1)*p));
    end;
    Scpectrummat     = (1/(2*pi))*inv(eye(n)-term_1)*Sigmamat*inv(eye(n)-term_2);
    DiagSpect(:,k)   = diag(real(Scpectrummat));
%     FullSpect(:,:,k) = real(Scpectrummat);
%     kk(k,1) = k;
    tempcohere = zeros(n,n);
    for vv  = 1 : n;
        for vk = 1 : n;
%             GainSpec(vv,vk,k)    = ((real(Scpectrummat(vv,vk))^2) + (imag(Scpectrummat(vv,vk))^2))^0.5;
            tempcohere(vv,vk)      = ((real(Scpectrummat(vv,vk))^2) + (imag(Scpectrummat(vv,vk))^2))...
                                    /(real(Scpectrummat(vv,vv))*real(Scpectrummat(vk,vk)));            
%             PhaseSpec(vv,vk,k)   =  atan(imag(Scpectrummat(vv,vk))/real(Scpectrummat(vv,vk)));            
        end;
    end;
    CohereSpec(:,:,k) = H*tempcohere*H';
end;
DiagSpect = H*DiagSpect;
