clear
clc

%%%%%benchmark calibration
%%%%%-------------pass-through---------------------------------------------
%%%%%%%%
thetaFbig=0.0001:0.01:0.9;
yyx=[];
yy1=[];
out1=[];
out2=[];
out3=[];
for k=1:length(thetaFbig);

beta = 0.99;                %discount factor
sigma = 1;  %intertemporal elasticity of substituion
eta =  1.5;    %intratemporal elasticity of substituion
phi = 3;    %inverse of frisch elasticity of labour supplu
alpha = 0.4;  %share of foreign goods in cpi basket
thetaH = 0.75;  %domestic output price calvo stickiness
thetaF = thetaFbig(k);  %domestic import price calvo stickiness
% pibar = theta(8);   %inflataion target
rhoR=0.65; %interest smoothing coefficient
rhopi=1.84; %inflation targeting coefficient
rhox=0.15; %output gap targeting coefficient
rhoa=0.9; %AR(1) coefficient for domestic produxtivity
rhoystar=0.86; %AR(1) coefficient for foreign output
sigma_a=0.71;
sigma_ystar=0.78;
sigma_er=0.7;
rho_epsa_epsy=0.3;

theta=[beta;sigma;eta;phi;alpha;thetaH;thetaF;rhoR;rhopi;rhox;rhoa;rhoystar];
[ PP,QQ,PROBLEM ] = model_matrices(theta);

if PROBLEM==0;
 Sigma=zeros(3,3);
Sigma(1,1)=sigma_er;
Sigma(2,2)=sigma_a;
Sigma(3,3)=sigma_ystar;
Sigma(2,3)=rho_epsa_epsy*sqrt(sigma_ystar*sigma_a);
Sigma(3,2)=rho_epsa_epsy*sqrt(sigma_ystar*sigma_a);   
    
   [DiagSpect, CohereSpec, omegafreq]=varspectrum(PP,QQ,eye(size(PP)),Sigma,100);

out1=[out1;[ ((sum(DiagSpect(9,:),2).^0.5)./sum(DiagSpect(4,:),2).^0.5) ((sum(DiagSpect(9,:),2).^0.5)./sum(DiagSpect(5,:),2).^0.5)]];
out2=[out2;squeeze(CohereSpec(9,4,8))];
out3=[out3;squeeze(CohereSpec(9,5,8))];


yyx=[yyx;thetaFbig(k)];
end

end





%%%%%%%
%%%%%-------------Domestic Price Stickiness---------------------------------------------
%%%%%%%%
thetaFbig=0.0001:0.01:0.9;
yyx=[];
yy1=[];
out4=[];
out5=[];
out6=[];
for k=1:length(thetaFbig);

beta = 0.99;                %discount factor
sigma = 1;  %intertemporal elasticity of substituion
eta =  1.5;    %intratemporal elasticity of substituion
phi = 3;    %inverse of frisch elasticity of labour supplu
alpha = 0.4;  %share of foreign goods in cpi basket
thetaH = thetaFbig(k);  %domestic output price calvo stickiness
thetaF = 0.75;  %domestic import price calvo stickiness
% pibar = theta(8);   %inflataion target
rhoR=0.65; %interest smoothing coefficient
rhopi=1.84; %inflation targeting coefficient
rhox=0.15; %output gap targeting coefficient
rhoa=0.9; %AR(1) coefficient for domestic produxtivity
rhoystar=0.86; %AR(1) coefficient for foreign output
sigma_a=0.71;
sigma_ystar=0.78;
sigma_er=0.7;
rho_epsa_epsy=0.3;

theta=[beta;sigma;eta;phi;alpha;thetaH;thetaF;rhoR;rhopi;rhox;rhoa;rhoystar];
[ PP,QQ,PROBLEM ] = model_matrices(theta);

if PROBLEM==0;
 Sigma=zeros(3,3);
Sigma(1,1)=sigma_er;
Sigma(2,2)=sigma_a;
Sigma(3,3)=sigma_ystar;
Sigma(2,3)=rho_epsa_epsy*sqrt(sigma_ystar*sigma_a);
Sigma(3,2)=rho_epsa_epsy*sqrt(sigma_ystar*sigma_a);   
    
   [DiagSpect, CohereSpec, omegafreq]=varspectrum(PP,QQ,eye(size(PP)),Sigma,100);

out4=[out4;[ ((sum(DiagSpect(9,:),2).^0.5)./sum(DiagSpect(4,:),2).^0.5) ((sum(DiagSpect(9,:),2).^0.5)./sum(DiagSpect(5,:),2).^0.5)]];
out5=[out5;squeeze(CohereSpec(9,4,8))];
out6=[out6;squeeze(CohereSpec(9,5,8))];


yyx=[yyx;thetaFbig(k)];
end

end




%%%%%%%%monetary policy
%%%%%%%
%%%%%-------------Domestic Price Stickiness---------------------------------------------
%%%%%%%%
thetaFbig=1.0001:0.05:3;
yyxm=[];
yy1=[];
out7=[];
out8=[];
out9=[];
for k=1:length(thetaFbig);

beta = 0.99;                %discount factor
sigma = 1;  %intertemporal elasticity of substituion
eta =  1.5;    %intratemporal elasticity of substituion
phi = 3;    %inverse of frisch elasticity of labour supplu
alpha = 0.4;  %share of foreign goods in cpi basket
thetaH = 0.75;  %domestic output price calvo stickiness
thetaF = 0.75;  %domestic import price calvo stickiness
% pibar = theta(8);   %inflataion target
rhoR=0.65; %interest smoothing coefficient
rhopi=thetaFbig(k); %inflation targeting coefficient
rhox=0.15; %output gap targeting coefficient
rhoa=0.9; %AR(1) coefficient for domestic produxtivity
rhoystar=0.86; %AR(1) coefficient for foreign output
sigma_a=0.71;
sigma_ystar=0.78;
sigma_er=0.7;
rho_epsa_epsy=0.3;

theta=[beta;sigma;eta;phi;alpha;thetaH;thetaF;rhoR;rhopi;rhox;rhoa;rhoystar];
[ PP,QQ,PROBLEM ] = model_matrices(theta);

if PROBLEM==0;
 Sigma=zeros(3,3);
Sigma(1,1)=sigma_er;
Sigma(2,2)=sigma_a;
Sigma(3,3)=sigma_ystar;
Sigma(2,3)=rho_epsa_epsy*sqrt(sigma_ystar*sigma_a);
Sigma(3,2)=rho_epsa_epsy*sqrt(sigma_ystar*sigma_a);   
    
   [DiagSpect, CohereSpec, omegafreq]=varspectrum(PP,QQ,eye(size(PP)),Sigma,100);

out7=[out7;[ ((sum(DiagSpect(9,:),2).^0.5)./sum(DiagSpect(4,:),2).^0.5) ((sum(DiagSpect(9,:),2).^0.5)./sum(DiagSpect(5,:),2).^0.5)]];
out8=[out8;squeeze(CohereSpec(9,4,8))];
out9=[out9;squeeze(CohereSpec(9,5,8))];


yyxm=[yyxm;thetaFbig(k)];
end

end






























figure(1)
set(0,'DefaultAxesColorOrder',[1 0 0],...
      'DefaultAxesLineStyleOrder','-|-.|-.|:')

subplot(3,3,1)


plot(yyx,out1)
legend('Relative to inflation','Relative to output');
xlabel('\theta_{f}');
ylabel('Changes in Import Price pass-through');
title('Standard Deviation of the real exchange rate')
axis tight
subplot(3,3,2)
plot(yyx,out2)
xlabel('\theta_{f}');
title('Business Cycle Coherence between the real exchange rate and inflation')
axis tight
subplot(3,3,3)
plot(yyx,out3)
xlabel('\theta_{f}');
title('Business Cycle Coherence between the real exchange rate and output')
axis tight

subplot(3,3,4)
plot(yyx,out4)
xlabel('\theta_{h}');
ylabel('Changes in domestic price stickiness');
legend('Relative to inflation','Relative to output');

%title('Standard Deviation of the real exchange rate')
axis tight
subplot(3,3,5)
plot(yyx,out5)
xlabel('\theta_{h}');
%title('Correlation between the real exchange rate and domestic inflation')
axis tight
subplot(3,3,6)
plot(yyx,out6)
xlabel('\theta_{h}');

axis tight





subplot(3,3,7)
plot(yyxm,out7)
xlabel('\rho_{\pi}');
ylabel('Changes in Monetary Policy Rule');
legend('Relative to inflation','Relative to output');

%title('Standard Deviation of the real exchange rate')
axis tight
subplot(3,3,8)
plot(yyxm,out8)
xlabel('\rho_{\pi}');
%title('Correlation between the real exchange rate and domestic inflation')
axis tight
subplot(3,3,9)
plot(yyxm,out9)
xlabel('\rho_{\pi}');

axis tight

