function [ PP,QQ,PROBLEM ] = model_matrices(theta)
% produce the states space solution of the model give by:
% GAM0*y(t) = GAM1*y(t-1) + C + PSI*z(t) + PPI*eta(t).
% and the solution is solved by sims gensys given by
% y(t) = PP*y(t-1) + QQ*z(t)
% note: PP and QQ does not include the expectation terms, same form as uhlig            
%==========================================================================
% Orginal author: Philip Liu , April 2007
%==========================================================================
% Inputs: 
%   Theta = vector of parameters
% % Output:   Y(t) = PP Y(t-1) + QQ z(t)
%           PROBLEM indicator
% Functions called:
%           sim's gensysct.m (see options below)
%   
%==========================================================================

%%  SETTING  PARAMETERS:




beta = theta(1);                %discount factor
sigma = theta(2);  %intertemporal elasticity of substituion
eta = theta(3);    %intratemporal elasticity of substituion
phi = theta(4);    %inverse of frisch elasticity of labour supplu
alpha = theta(5);  %share of foreign goods in cpi basket
thetaH = theta(6);  %domestic output price calvo stickiness
thetaF = theta(7);  %domestic import price calvo stickiness
% pibar = theta(8);   %inflataion target
rhoR=theta(8); %interest smoothing coefficient
rhopi=theta(9); %inflation targeting coefficient
rhox=theta(10); %output gap targeting coefficient
rhoa=theta(11); %AR(1) coefficient for domestic produxtivity
rhoystar=theta(12); %AR(1) coefficient for foreign output
omegas=1+(alpha*(2-alpha)*((sigma*eta)-1));
omegasi=1+(alpha*((sigma*eta)-1));
lamdah=((1-thetaH)*(1-thetaH*beta))/thetaH;
kappax=lamdah*(phi+(sigma/omegas))
%kappasi=lamdah*(1-(omegasi/omegas))
lamdaf=((1-thetaF)*(1-thetaF*beta))/thetaF;  %check

kappasi=(((1-thetaH)*(1-beta*thetaH)/thetaH)*(1-(1+alpha*(sigma*eta-1)/(1+alpha*(2-alpha)*(sigma*eta-1)))));
%(((1-thetaH)*(1-beta*thetaH)/thetaH)*(phi+(sigma/(1+alpha*(2-alpha)*(sigma*eta-1)))))



%********************************************************************
%*      matrices of canonical system
%********************************************************************/

%* equation indices **/
eq_A1   = 1;   
eq_A2       = 2;  
eq_A3       = 3;   
eq_A4      = 4;  
eq_A5   = 5;   
eq_A6    = 6;   
eq_A7     = 7;  
eq_A8=8;
eq_A9=9;
eq_A10=10;
eq_A11=11;
eq_A12=12;
eq_A13=13;
eq_A14=14;
eq_A15=15;
eq_A16=16;
eq_A17=17;
eq_EC=18;
eq_EPI=19;
eq_EPIH=20;
eq_EPIF=21;




%* variable indices **/
v_c     = 1;
v_r        = 2;
v_pih          = 3;
v_pi          =4;
v_x          =5;
v_y      = 6;  %* E[x] **/
v_yn     = 7;  %* E[pi] **/
v_s=8;
v_q=9;
v_e=10;
v_psif=11;
v_pf=12;
v_ph=13;
v_pif=14;
v_deltae=15;
v_a=16;
v_ystar=17;
v_EC=18;
v_EPI=19;
v_EPIH=20;
v_EPIF=21;

%* shock indices **/
e_a     = 2;
e_ystar = 3;
e_r = 1;


%* expectation error indices **/
n_EC        = 1;
n_EPI      = 2;
n_EPIH=       3;
n_EPIF=      4;


%* summary **/
neq  = 21;
neps = 3;
neta = 4;

%* initialize matrices **/
GAM0 = zeros(neq,neq);
GAM1 = zeros(neq,neq);
   C = zeros(neq,1);
 PSI = zeros(neq,neps);
 PPI = zeros(neq,neta);

%% equations
% GAM0 y(t) = GAM1 y(t-1) + C + PSI z(t) + PPI eta(t) 
%*********************************************************
%**      1. A1
%*********************************************************/
GAM0(eq_A1,v_c)  =  1;
GAM0(eq_A1,v_EC)  =  -1;
GAM0(eq_A1,v_r)  =  1/sigma;
GAM0(eq_A1,v_EPI)  =  -1/sigma;


%*********************************************************
%**      1. A2
%*********************************************************/
GAM0(eq_A2,v_pih)  =  1;
GAM0(eq_A2,v_EPIH)  =  -beta;
GAM0(eq_A2,v_x)  =  -kappax;
GAM0(eq_A2,v_psif)  =  -kappasi;


%*********************************************************
%**      1. A3
%*********************************************************/
GAM0(eq_A3,v_y)  =  1;
GAM0(eq_A3,v_ystar)  =  -1;
GAM0(eq_A3,v_s)  =  -(1/sigma)*omegas;
GAM0(eq_A3,v_psif)  =  -(1/sigma)*omegasi;


%*********************************************************
%**      1. A4
%*********************************************************/
GAM0(eq_A4,v_c)  =  1;
GAM0(eq_A4,v_ystar)  =  -1;
GAM0(eq_A4,v_q)  =  -(1/sigma);


%*********************************************************
%**      1. A5
%*********************************************************/
GAM0(eq_A5,v_q)  =  1;
GAM0(eq_A5,v_psif)  =  -1;
GAM0(eq_A5,v_s)  =  -(1-alpha);


%*********************************************************
%**      1. A6
%*********************************************************/
GAM0(eq_A6,v_psif)  =  1;
GAM0(eq_A6,v_e)  =  -1;
GAM0(eq_A6,v_pf)  =  1;


%*********************************************************
%**      1. A7
%*********************************************************/
GAM0(eq_A7,v_pif)  =  1;
GAM0(eq_A7,v_EPIF)  =  -beta;
GAM0(eq_A7,v_psif)  =  -(lamdaf);


%*********************************************************
%**      1. A8
%*********************************************************/
GAM0(eq_A8,v_pi)  =  1;
GAM0(eq_A8,v_pih)  =  -(1-alpha);
GAM0(eq_A8,v_pif)  =  -(alpha);


%*********************************************************
%**      1. A9
%*********************************************************/
GAM0(eq_A9,v_s)  =  1;
GAM0(eq_A9,v_pf)  =  -1;
GAM0(eq_A9,v_ph)  =  1;

% GAM0 y(t) = GAM1 y(t-1) + C + PSI z(t) + PPI eta(t) 
%*********************************************************
%**      1. A10
%*********************************************************/
GAM0(eq_A10,v_pih)  =  1;
GAM0(eq_A10,v_ph)  =   -1;
GAM1(eq_A10,v_ph)  =  -1;


%*********************************************************
%**      1. A11
%*********************************************************/
GAM0(eq_A11,v_pif)  =  1;
GAM0(eq_A11,v_pf)  =  -1;
GAM1(eq_A11,v_pf)  =  -1;
%*********************************************************
%**      1. A12
%*********************************************************/
GAM0(eq_A12,v_x)  =  1;
GAM0(eq_A12,v_y)  =  -1;
GAM0(eq_A12,v_yn)  =  1;
%*********************************************************
%**      1. A13
%*********************************************************/
GAM0(eq_A13,v_yn)  =  1;
GAM0(eq_A13,v_a)  =  -((omegas*(1+phi))/(sigma+phi*omegas));
GAM0(eq_A13,v_ystar)  =  -1*((sigma*(1-(1+alpha*(2-alpha)*(sigma*eta-1)))));%-((sigma*(1-omegas))/(sigma+phi*omegas));

% (1/(sigma+phi*(1+alpha*(2-alpha)*(sigma*eta-1))))*((1+alpha*(2-alpha)*(sigma*eta-1))*(1+phi))
% ((omegas*(1+phi))/(sigma+phi*omegas))
% ((sigma*(1-omegas))/(sigma+phi*omegas))
% (sigma*(1-(1+alpha*(2-alpha)*(sigma*eta-1))))
% yflex=(1/(sigma+chi*(1+alpha*(2-alpha)*(sigma*eta-1))))*((1+alpha*(2-alpha)*(sigma*eta-1))*(1+chi)*a+
% (sigma*(1-(1+alpha*(2-alpha)*(sigma*eta-1))))*ystar);
%*********************************************************
%**      1. A14
%*********************************************************/

GAM0(eq_A14,v_r)  =  1;
GAM1(eq_A14,v_r)  =  rhoR;
GAM0(eq_A14,v_pi)  =  -1*((1-rhoR)*rhopi);
GAM0(eq_A14,v_x)  =  -1*((1-rhoR)*rhox);
 PSI(eq_A14,e_r) = 1;
 
 
 %*********************************************************
%**      1. A15
%*********************************************************/
GAM0(eq_A15,v_deltae)  =  1;
GAM0(eq_A15,v_e)  =  -1;
GAM1(eq_A15,v_e)  =  -1;


%*********************************************************
%**      1. A16
%*********************************************************/
GAM0(eq_A16,v_a)  =  1;
GAM1(eq_A16,v_a)  =  rhoa;
PSI(eq_A16,e_a) = 1;


%*********************************************************
%**      1. A17
%*********************************************************/
GAM0(eq_A17,v_ystar)  =  1;
GAM1(eq_A17,v_ystar)  =  rhoystar;
PSI(eq_A17,e_ystar) = 1;


%*********************************************************
%**      Expectation error
%**********************************************************/

%EC
GAM0(eq_EC,v_c)  = 1;
GAM1(eq_EC,v_EC) = 1;
 PPI(eq_EC,n_EC)  = 1;
%* E(pi) **/
GAM0(eq_EPI,v_pi)  = 1;
GAM1(eq_EPI,v_EPI) = 1;
 PPI(eq_EPI,n_EPI)  = 1;
 %* E(pih) **/
GAM0(eq_EPIH,v_pih)  = 1;
GAM1(eq_EPIH,v_EPIH) = 1;
 PPI(eq_EPIH,n_EPIH)  = 1;
  %* E(pif) **/
GAM0(eq_EPIF,v_pif)  = 1;
GAM1(eq_EPIF,v_EPIF) = 1;
 PPI(eq_EPIF,n_EPIF)  = 1;
 
 
%*******************************************************************
%**      QZ(generalized Schur) decomposition by GENSYS
%********************************************************************/

PROBLEM=0;	
div =1.0000000001;        % criteria for stable roots
% y(t) = T1*y(t-1) + TC + T0*z(t)
% A, B, Q and Z are the QZ decomp matrix
% RC(1) = 1 => existence
% RC(2) = 1 => Unique
[T1,TC,T0,Q,A,B,Z,RC] = gensys(GAM0,GAM1,C,PSI,PPI,div);
% T1
% T0
% [T1x,TCx,T0x,Qx,Ax,Bx,Zx,RCx] = gensysct(GAM0,GAM1,C,PSI,PPI,div);
% Q
% Qx
% PP = T1(1:neq-neta,1:neq-neta);
% QQ = T0(1:neq-neta,:);

%dont worry
ZZ = zeros(neq-neta);
ZZ(1:neq-neta,1:neq-neta) = T1(1:neq-neta,1:neq-neta);

PP = ZZ;
QQ = [T0(1:neq-neta,:)];
RC
if RC(1)~=1 || RC(2)~=1  % non-unique and existence
    PROBLEM=1;
end


