!  irfcode.f90 
!
!  FUNCTIONS/SUBROUTINES exported from irfcode.dll:
!  irfcode - subroutine 
!
subroutine irf(s1,Cq1,v1,a1,g,Cqa,ymat1,horz1,reps,n1,l1,nn,nn1,nn2,a0,out,outs1,outs2,outs3,outs4,h,cv,cholhmat)

!DEC$ attributes dllexport, alias: 'irf' :: irf
implicit none
  ! Variables
  !nn=n*(n*l+1)
  !nn1=n*(n-1)/2
  !nn2=n*l+1
  real(8) n1,l1,nn,reps,nn1,horz1,nn2
  real(8) s1(1,int(nn)),Cq1(int(nn),int(nn)),v1(1,int(n1)),a1(1,int(nn1)),g(1,int(n1))
  real(8) Cqa(int(nn1),int(nn1)),ymat1(int(l1),int(n1)),a0(int(n1),int(n1))
  real(8) out(int(horz1),int(n1)),outs1(int(horz1),int(n1)),outs2(int(horz1),int(n1)),outs3(int(horz1),int(n1)),outs4(int(horz1),int(n1))
  real(8) ss(int(horz1),int(nn)),aa(int(horz1),int(nn1)),vv(int(horz1),int(n1)),ymat(int(horz1),int(n1))
  real(8) ymats1(int(horz1),int(n1)),ymats2(int(horz1),int(n1)),ymats3(int(horz1),int(n1)),ymats4(int(horz1),int(n1)),resid(int(horz1),int(n1))
  real(8) zero,one,ev(int(horz1),int(n1)),ea(int(horz1),int(nn1)),hmat(int(n1),int(n1)),cv(int(n1),int(n1)),icv(int(n1),int(n1))
  real(8) H(int(n1),int(n1)),cholhmat(int(n1),int(n1)),es(int(horz1),int(nn)),xx(1,int(nn2)),xx1(1,int(nn2)),xx2(1,int(nn2)),xx3(1,int(nn2)),xx4(1,int(nn2))
  real(8) beta(int(nn2),int(n1)),resid1(1,int(n1)),ytemp(1,int(n1)),ytemp1(1,int(n1)),ytemp2(1,int(n1)),ytemp3(1,int(n1)),ytemp4(1,int(n1)),temps(1,int(nn2))
  
  integer n,l,seed(4),info,i,j,jj
  
  !initialise
  zero=real(0,8)
  one=real(1,8)
  out=zero
  outs1=zero
  outs2=zero
  outs3=zero
  outs4=zero
  seed(1)=1
seed(2)=2
seed(3)=3
seed(4)=5
  n=int(n1)
  l=int(l1)
  !monte-carlo replications
  do i=1,int(reps)
  !initialise simulation
  ss=zero
  ss(l,1:int(nn))=s1(1,1:int(nn))
  aa=zero
  aa(l,1:int(nn1))=a1(1,1:int(nn1))
  vv=zero
  vv(l,1:n)=v1(1,1:n)
  ymat=zero
  ymat(1:2,1:n)=ymat1(1:2,1:n)
  ymats1=zero
  ymats1(1:2,1:n)=ymat1(1:2,1:n)
  ymats2=zero
  ymats2(1:2,1:n)=ymat1(1:2,1:n)
  ymats3=zero
  ymats3(1:2,1:n)=ymat1(1:2,1:n)
  ymats4=zero
  ymats4(1:2,1:n)=ymat1(1:2,1:n)
  call rndn(int(horz1),n,resid,seed) !var resids
   call rndn(int(horz1),n,ev,seed) !
    call mnorm(Cqa,int(horz1),int(nn1),ea,seed,.false.)
    call mnorm(Cq1,int(horz1),int(nn),es,seed,.false.)


 ! simulate VAR for the first period
 j=l+1
 
 !variance
 do jj=1,n
 vv(j,jj)=vv(j-1,jj)+ev(j,jj)*dsqrt(g(1,jj))
 enddo
 !offdiagonal
 do jj=1,int(nn1)
  aa(j,jj)=aa(j-1,jj)+ea(j,jj)
  enddo
  

!simulate coefficients
 do jj=1,int(nn)
ss(j,jj)=ss(j-1,jj)+es(j,jj)
enddo

!reshape coefficients
 beta(1:int(nn2),1)=ss(j,1:int(nn2))
 beta(1:int(nn2),2)=ss(j,int(nn2)+1:int(nn2)*2)
 beta(1:int(nn2),3)=ss(j,(int(nn2)*2)+1:int(nn2)*3)
 beta(1:int(nn2),4)=ss(j,(int(nn2)*3)+1:int(nn))
 
!create RHS of the VAR
xx(1,1:n)=ymat(j-1,1:n)
xx(1,n+1:n*2)=ymat(j-2,1:n)
xx(1,n*l+1)=one
!
xx1(1,1:n)=ymats1(j-1,1:n)
xx1(1,n+1:n*2)=ymats1(j-2,1:n)
xx1(1,n*l+1)=one
!
xx2(1,1:n)=ymats2(j-1,1:n)
xx2(1,n+1:n*2)=ymats2(j-2,1:n)
xx2(1,n*l+1)=one
!
xx3(1,1:n)=ymats3(j-1,1:n)
xx3(1,n+1:n*2)=ymats3(j-2,1:n)
xx3(1,n*l+1)=one
!
xx4(1,1:n)=ymats4(j-1,1:n)
xx4(1,n+1:n*2)=ymats4(j-2,1:n)
xx4(1,n*l+1)=one

!simulate VAR for 1st period
ytemp=matmul(xx,beta)
ymat(j,1:n)=ytemp(1,1:n)

ytemp1=matmul(xx1,beta)
ymats1(j,1:n)=ytemp1(1,1:n)+a0(1,1:n)
ytemp2=matmul(xx2,beta)
ymats2(j,1:n)=ytemp2(1,1:n)+a0(2,1:n)
ytemp3=matmul(xx3,beta)
ymats3(j,1:n)=ytemp3(1,1:n)+a0(3,1:n)
ytemp4=matmul(xx4,beta)
ymats4(j,1:n)=ytemp4(1,1:n)+a0(4,1:n)


! simulate VAR for remaining periods
 do j=l+2,int(horz1)

!variance
 do jj=1,n
 vv(j,jj)=vv(j-1,jj)+ev(j,jj)*dsqrt(g(1,jj))
 enddo
 !offdiagonal
 do jj=1,int(nn1)
  aa(j,jj)=aa(j-1,jj)+ea(j,jj)
  enddo
  


  !create covariance matrix
  cv=zero
  do jj=1,n
  cv(jj,jj)=one
  H(jj,jj)=dexp(vv(j,jj))
  if (H(jj,jj) .lt. zero) then
  H(jj,jj)=dabs(H(jj,jj))
  endif
  enddo
cv(2,1)=aa(j,1)
cv(3,1)=aa(j,2)
cv(3,2)=aa(j,3)
cv(4,1)=aa(j,4)
cv(4,2)=aa(j,5)
cv(4,3)=aa(j,6)
call invert(cv,n,icv)
hmat=matmul(matmul(icv,H),transpose(icv))
call cholx(CHOLhmat,hmat,n)
!test for numerical problems
IF(ANY(IsNaN(CHOLhmat))) then
CHOLhmat=a0
endif
 
resid1(1,1:n)=matmul(resid(j,1:n),CHOLhmat)
!simulate coefficients
!simulate coefficients
do jj=1,int(nn)
ss(j,jj)=ss(j-1,jj)+es(j,jj)
enddo

!reshape coefficients
 beta(1:int(nn2),1)=ss(j,1:int(nn2))
 beta(1:int(nn2),2)=ss(j,int(nn2)+1:int(nn2)*2)
 beta(1:int(nn2),3)=ss(j,(int(nn2)*2)+1:int(nn2)*3)
 beta(1:int(nn2),4)=ss(j,(int(nn2)*3)+1:int(nn))
 
!create RHS of the VAR
xx(1,1:n)=ymat(j-1,1:n)
xx(1,n+1:n*2)=ymat(j-2,1:n)
xx(1,n*l+1)=one
!
xx1(1,1:n)=ymats1(j-1,1:n)
xx1(1,n+1:n*2)=ymats1(j-2,1:n)
xx1(1,n*l+1)=one
!
xx2(1,1:n)=ymats2(j-1,1:n)
xx2(1,n+1:n*2)=ymats2(j-2,1:n)
xx2(1,n*l+1)=one
!
xx3(1,1:n)=ymats3(j-1,1:n)
xx3(1,n+1:n*2)=ymats3(j-2,1:n)
xx3(1,n*l+1)=one
!
xx4(1,1:n)=ymats4(j-1,1:n)
xx4(1,n+1:n*2)=ymats4(j-2,1:n)
xx4(1,n*l+1)=one


!simulate VAR for remaining period




ytemp=matmul(xx,beta)
ymat(j,1:n)=ytemp(1,1:n)+resid1(1,1:n)
ytemp1=matmul(xx1,beta)
ymats1(j,1:n)=ytemp1(1,1:n)+resid1(1,1:n)
ytemp2=matmul(xx2,beta)
ymats2(j,1:n)=ytemp2(1,1:n)+resid1(1,1:n)
ytemp3=matmul(xx3,beta)
ymats3(j,1:n)=ytemp3(1,1:n)+resid1(1,1:n)
ytemp4=matmul(xx4,beta)
ymats4(j,1:n)=ytemp4(1,1:n)+resid1(1,1:n)














enddo !end simulation loop

out=out+ymat
outs1=outs1+ymats1
outs2=outs2+ymats2
outs3=outs3+ymats3
outs4=outs4+ymats4
enddo !end monte-carlo loop

!take averages
out=out/reps
outs1=outs1/reps
outs2=outs2/reps
outs3=outs3/reps
outs4=outs4/reps



end subroutine irf






















subroutine eig(A,N,WR,WI,WA)
implicit none
integer N,LDA,LDVL,LDVR,LWORK,INFO,i
real(8) A(N,N)
DOUBLE PRECISION,dimension(N)::WR,WI,WA
DOUBLE PRECISION,dimension(N,N)::VL,VR
DOUBLE PRECISION,dimension(3*N)::WORK
CHARACTER*1 JOBVL,JOBVR 

!define options
JOBVL='N'
JOBVR='N'
LDA=N
LDVL=N
LDVR=N
LWORK=3*N

call DGEEV( JOBVL, JOBVR, N, A, LDA, WR, WI, VL, LDVL, VR,LDVR, WORK, LWORK, INFO )

do i=1,N
  WA(i)=dsqrt((WR(i)**2)+(WI(i)**2))
  enddo

end subroutine eig






subroutine rcond(A,N,rcondition)
implicit none
integer N,NN
real(8) A(N,N)
real(8) NORM
external DGECON,DGETRF
DOUBLE PRECISION WORK(N),WORK1(4*N),out(N,N),rcondition,DLANGE
integer IPIV(N),INFO,IWORK(N)

!estimate 1-norm 
NORM=DLANGE( '1', N, N, A, N, WORK )
!lU factorisation
out=A
call DGETRF( N, N, OUT, N, IPIV, INFO )

!estimate Rcondition number
call DGECON( '1', N, OUT, N, NORM, rcondition, WORK1, IWORK,INFO )

end subroutine rcond















subroutine invertsym(A,N,OUT)
implicit none
integer,intent(in)::N
real(8),intent(in)::A(N,N)
real(8),intent(out)::OUT(N,N)
integer info,i,j
external DPOTRF,DPOTRI

OUT=A
!chol factorisation
call DPOTRF('U',N,OUT,N,info)
!Inverse
call DPOTRI('U',N,OUT,N,info)
do i=1,n
do j=i+1,n
out(j,i)=out(i,j)
end do
end do

end subroutine invertsym


subroutine invert(A,N,OUT)
implicit none

integer,intent(in)::N
real(8),intent(in)::A(N,N)
real(8),intent(out)::OUT(N,N)
DOUBLE PRECISION WORK(N)
integer IPIV(N),INFO,LWORK
external DGETRI,DGETRF
LWORK=N
OUT=A
!lU factorisation
call DGETRF( N, N, OUT, N, IPIV, INFO )

!Inverse
call DGETRI( N, OUT, N, IPIV, WORK, LWORK, INFO )

end subroutine invert





subroutine repmatr(x,copies,ncols,out)
implicit none

integer ncols,copies,i
real(8),dimension(1,ncols)::x
real(8),dimension(copies,ncols)::out
do i=1,copies
out(i,1:ncols)=x(1,1:ncols)
end do
end subroutine repmatr


subroutine mnorm(cov,nrows,ncols,out,seed,flag)
implicit none

integer nrows,ncols,info
integer seed(4)
real(8),dimension(ncols,ncols)::cov
real(8),dimension(ncols,ncols)::cfactor
real(8),dimension(nrows,ncols)::out
real(8),dimension(nrows,ncols)::temp
logical flag
call rndn(nrows,ncols,temp,seed)
if (flag) then
call cholesky(cfactor,cov,ncols,info)

out=matmul(temp,cfactor)
else
out=matmul(temp,cov)
end if
end subroutine mnorm



 
 
 
 

subroutine rndn(N,C,OUT,ISEED)
implicit none

external DLARNV
integer IDIST,i
integer,intent(IN)::N,C
integer,intent(IN)::ISEED(4)
real(8)::X(N)
real(8),intent(OUT)::OUT(N,C)
IDIST=3

do i=1,C
call DLARNV( IDIST, ISEED, N, X )
OUT(1:N,i)=X(1:N)
end do

end subroutine rndn






subroutine cholesky(out1,in1,n,info)
implicit none

external DPOTRF
integer n,info,i,j
real(8),dimension(n,n)::out1
real(8),dimension(n,n)::in1
out1(1:n,1:n)=in1(1:n,1:n)
call DPOTRF('U',n,out1,n,info)
do i=1,n
do j=i+1,n
out1(j,i)=real(0,8)
end do
end do
endsubroutine

subroutine svd(in1,S1,U,VT,n)
    implicit none
    external DGESVD
    character JOBU, JOBVT
    real(8) in1(n,n),S1(n,n)
     INTEGER   INFO, LDA, LDU, LDVT, LWORK, M, N,i
     DOUBLE PRECISION   A( n,n ), S( n ), U( n, n ),VT( n, n ), WORK(5*n)
     LWORK=5*N
     A=in1
      JOBU   ='A'
      JOBVT='A'

 call DGESVD( JOBU, JOBVT, N, N, A, N, S, U, N, VT, N,WORK, LWORK, INFO )
 do i=1,n
 S1(i,i)=S(i)
 enddo
   
end subroutine svd

subroutine cholx(out1,in1,n)
implicit none

integer n,info1
real(8),dimension(n,n)::out1
real(8),dimension(n,n)::in1
real(8) S(n,n),U(n,n),VT(n,n),S2(n,n),C(n,n)
call cholesky(out1,in1,n,info1)
if (info1 .ne. 0) then
!singular value decomposition
call svd(in1,S,U,VT,n)
S2=dsqrt(S)
C=MATMUL(matmul(U,S2),TRANSPOSE(VT))
out1=C
endif
end subroutine cholx